/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class TestInjectionCRLF
extends AbstractAppParamPlugin {
    private static Random staticRandomGenerator = new Random();
    private String randomString = "Tamper=" + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
    private String cookieTamper1 = "%0D%0ASet-cookie:%20" + this.randomString + "%0D%0A";
    private String cookieTamper2 = "%0ASet-cookie:%20" + this.randomString + "%0A";
    private String[] PARAM_LIST = new String[]{this.cookieTamper1, this.cookieTamper2};
    private Pattern patternCookieTamper = Pattern.compile("Set-cookie: " + this.randomString, 10);

    public int getId() {
        return 40001;
    }

    public String getName() {
        return "CRLF injection";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Cookie can be set via CRLF injection.  It may also be possible to set arbitrary HTTP response header.\r\nIn addition, by carefully crafting the injected response cross-site script, cache poisiong vulnerability may also exist.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        return "Type check the submitted parameter carefully.  Do not allow CRLF to be injected by filtering CRLF.";
    }

    public String getReference() {
        String string = "http://www.sanctuminc.com/pdf/whitepaper_httpresponse.pdf\r\nhttp://webappfirewall.com/lib/crlf-injection.txtnull";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        String string3 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        for (int i = 0; i < this.PARAM_LIST.length; ++i) {
            httpMessage = this.getNewMsg();
            string3 = this.setParameter(httpMessage, string, this.PARAM_LIST[i]);
            try {
                this.sendAndReceive(httpMessage);
                if (!this.checkResult(httpMessage, string3)) continue;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean checkResult(HttpMessage httpMessage, String string) {
        if (httpMessage.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        Matcher matcher = this.patternCookieTamper.matcher(httpMessage.getResponseHeader().toString());
        if (matcher.find()) {
            this.bingo(2, 1, null, string, "", httpMessage);
            return true;
        }
        return false;
    }
}

