/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestObsoleteFileExtended
extends AbstractAppPlugin {
    private static final String[] staticSuffixList = new String[]{".OLD", ".Old", ".BAK", ".Bak", ".java", ".INC", ".Inc"};
    private static final String[] staticAppendixList = new String[]{"~"};
    private static final Pattern patternNotFound = Pattern.compile("(\\bNot\\sfound\\b)|(\\b404\\b)", 10);

    public int getId() {
        return 5;
    }

    public String getName() {
        return "Obsolete file extended check";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "Miscellenous include files, backup, unused or obsolete files exist as indicated.  If these files contain program source, information such as server logic or ODBC/JDBC user ID and passwords may be revealed since these file extension may not be processed by the web server.";
    }

    public String getSolution() {
        return "Remove backup, unused or obsolete files.  For include files, carefully choose the suffix to prevent information disclosure.";
    }

    public String getReference() {
        return "";
    }

    public int getCategory() {
        return 0;
    }

    public void init() {
    }

    public void scan() {
        int n;
        for (n = 0; n < staticSuffixList.length; ++n) {
            try {
                this.testSuffix(staticSuffixList[n], false);
                this.testSuffix(staticSuffixList[n], true);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (n = 0; n < staticAppendixList.length; ++n) {
            try {
                this.testSuffix(staticAppendixList[n], false);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void testSuffix(String string, boolean bl) throws IOException {
        int n;
        HttpMessage httpMessage = this.getNewMsg();
        URI uRI = httpMessage.getRequestHeader().getURI();
        String string2 = uRI.getPath();
        if (string2 == null || string2.equals("")) {
            return;
        }
        if (bl && (n = string2.lastIndexOf(".")) > -1) {
            string2 = string2.substring(0, n);
        }
        string2 = string2 + string;
        uRI.setPath(string2);
        httpMessage.getRequestHeader().setURI(uRI);
        this.sendAndReceive(httpMessage);
        if (!this.isFileExist(httpMessage)) {
            return;
        }
        this.bingo(1, 1, uRI.toString(), "", "", httpMessage);
    }
}

