/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.spider.Collector;
import org.parosproxy.paros.core.spider.Html;
import org.parosproxy.paros.core.spider.HttpMessageQueue;
import org.parosproxy.paros.core.spider.QueueItem;
import org.parosproxy.paros.core.spider.Spider;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpMethodHelper;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpStatusCode;

public class SpiderThread
extends Thread {
    private static final String[] NEGLECT_SUFFIXES = new String[]{"gif", "jpg", "bmp", "mp3", "arj", "doc", "swf", "pdf", "mpg", "wmv", "zip"};
    private static int threadCount = 1;
    private Spider parent = null;
    private boolean stop = false;
    private List queue = null;
    private HttpMessageQueue visitedLink = null;
    private HttpMethodHelper helper = new HttpMethodHelper();
    private boolean completed = false;
    private Collector collector = null;
    private int threadId = 0;

    SpiderThread(Spider spider) {
        this.parent = spider;
        this.queue = spider.getQueue();
        this.visitedLink = spider.getVisitedLink();
        this.collector = new Collector(this);
        this.setDaemon(true);
        this.setPriority(4);
        this.threadId = threadCount++;
    }

    boolean isStop() {
        return this.stop;
    }

    void setStop(boolean bl) {
        this.stop = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        QueueItem queueItem = null;
        while (!this.isStop() && !this.queue.isEmpty()) {
            try {
                List list = this.queue;
                synchronized (list) {
                    do {
                        queueItem = null;
                    } while (!this.queue.isEmpty() && (queueItem = (QueueItem)this.queue.remove(0)) != null && this.visitedLink.contains(queueItem.getMessage()));
                }
                if (queueItem == null) continue;
                this.parent.SpiderProgress(queueItem);
                this.crawl(queueItem.getMessage(), queueItem.getDepth());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.queue.isEmpty()) {
            this.completed = true;
        }
        this.parent.checkIfAllThreadCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMsgResponse(HttpMessage httpMessage) throws HttpException, IOException, HttpMalformedHeaderException {
        HttpResponseHeader httpResponseHeader = null;
        HttpMethod httpMethod = null;
        boolean bl = false;
        try {
            httpMethod = this.helper.createRequestMethod(httpMessage.getRequestHeader(), httpMessage.getRequestBody());
            httpMethod.setFollowRedirects(true);
            httpMethod.removeRequestHeader("If-Modified-Since");
            httpMethod.removeRequestHeader("If-None-Match");
            this.parent.getHttpSender().executeMethod(httpMethod);
            httpResponseHeader = HttpMethodHelper.getHttpResponseHeader(httpMethod);
            httpResponseHeader.setHeader("Transfer-encoding", null);
            if (this.isNeglectResponse(httpResponseHeader)) {
                boolean bl2 = false;
                return bl2;
            }
            httpMessage.setResponseHeader(httpResponseHeader);
            httpMessage.getResponseBody().append(httpMethod.getResponseBody());
            bl = true;
        }
        finally {
            httpMethod.releaseConnection();
        }
        return bl;
    }

    private void crawl(HttpMessage httpMessage, int n) {
        try {
            if ((httpMessage.getResponseHeader().isEmpty() || httpMessage.getResponseHeader().getStatusCode() == 304) && !this.readMsgResponse(httpMessage)) {
                return;
            }
            if (!HttpStatusCode.isSuccess(httpMessage.getResponseHeader().getStatusCode())) {
                return;
            }
            this.parent.readURI(httpMessage.cloneAll());
            Html html = new Html(httpMessage.getRequestHeader().getURI(), httpMessage.getResponseBody().toString());
            this.collector.collect(html, n);
            httpMessage.setResponseHeader(new HttpResponseHeader());
            httpMessage.getResponseBody().setBody("");
            this.parent.getVisitedLink().add(httpMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNeglect(HttpMessage httpMessage) throws URIException {
        Object object;
        int n;
        Object object2;
        boolean bl = false;
        URI uRI = httpMessage.getRequestHeader().getURI();
        if (!uRI.getScheme().equalsIgnoreCase("HTTP") && !uRI.getScheme().equalsIgnoreCase("HTTPS")) {
            return true;
        }
        String string = uRI.getHost().toUpperCase();
        if (!this.parent.isSeedScope(uRI) && !this.parent.getSpiderParam().isInScope(string)) {
            return true;
        }
        if (uRI.getPath() != null) {
            object2 = uRI.getPath().toUpperCase();
            for (n = 0; n < NEGLECT_SUFFIXES.length; ++n) {
                object = "." + NEGLECT_SUFFIXES[n];
                if (!((String)object2).endsWith((String)object)) continue;
                return true;
            }
        }
        if (this.visitedLink.contains(httpMessage)) {
            return true;
        }
        object2 = this.queue;
        synchronized (object2) {
            for (n = 0; n < this.queue.size(); ++n) {
                object = (QueueItem)this.queue.get(n);
                if (!((QueueItem)object).getMessage().equals(httpMessage)) continue;
                return true;
            }
        }
        return false;
    }

    private URI buildURI(URI uRI, String string) throws URIException {
        URI uRI2 = null;
        uRI2 = new URI(uRI, string, true);
        return uRI2;
    }

    void foundURI(HttpMessage httpMessage, String string, int n) throws URIException {
        httpMessage.getRequestHeader().setHeader("Referer", string);
        if (!this.isNeglect(httpMessage)) {
            this.parent.addQueue(httpMessage, n + 1);
            this.parent.foundURI(httpMessage);
        }
    }

    private boolean isNeglectResponse(HttpResponseHeader httpResponseHeader) {
        if (!HttpStatusCode.isSuccess(httpResponseHeader.getStatusCode())) {
            return true;
        }
        if (httpResponseHeader.isImage()) {
            return true;
        }
        if (httpResponseHeader.isText()) {
            return false;
        }
        return httpResponseHeader.getContentLength() > 200000;
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

