/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.hsqldb.Server;

public class DatabaseServer {
    String mServerProps;
    String mUrl;
    String mUser = "sa";
    String mPassword = "";
    Server mServer = null;
    Connection mConn = null;

    DatabaseServer(String string) throws ClassNotFoundException, Exception {
        this.start(string);
    }

    private void start(String string) throws ClassNotFoundException, Exception {
        string = string.replaceAll("\\\\", "/");
        this.mServerProps = "database.0=file:" + string;
        this.mUrl = "jdbc:hsqldb:hsql://localhost";
        this.mServer = new Server();
        this.mServer.putPropertiesFromString(this.mServerProps);
        this.mServer.setLogWriter(null);
        this.mServer.setErrWriter(null);
        Class.forName("org.hsqldb.jdbcDriver");
        this.mServer.start();
    }

    void shutdown() throws SQLException {
        Connection connection = this.getSingletonConnection();
        CallableStatement callableStatement = connection.prepareCall("SHUTDOWN");
        callableStatement.execute();
        this.mServer.signalCloseAllServerConnections();
        this.mServer.stop();
        boolean bl = true;
        for (int i = 0; i < 20 && bl; ++i) {
            try {
                this.mServer.checkRunning(false);
                bl = false;
                continue;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        this.mServer = null;
    }

    public Connection getNewConnection() throws SQLException {
        Connection connection = null;
        for (int i = 0; i < 2; ++i) {
            try {
                connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
                return connection;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (i == 4) {
                    throw sQLException;
                }
                System.out.println("Recovering " + i + " times.");
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return connection;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.mConn == null) {
            this.mConn = this.getNewConnection();
        }
        return this.mConn;
    }
}

