/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.view.View;

public class HistoryFilterDialog
extends AbstractDialog {
    private JPanel jPanel = null;
    private JButton btnApply = null;
    private JButton btnCancel = null;
    private JTextField txtPattern = null;
    private JPanel jPanel1 = null;
    private int exitResult = 2;
    private JButton btnReset = null;
    private JPanel jPanel2 = null;
    private JRadioButton radioExact = null;
    private JRadioButton radioRegex = null;

    public HistoryFilterDialog() throws HeadlessException {
        this.initialize();
    }

    public HistoryFilterDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setVisible(false);
        this.setResizable(false);
        this.setTitle("Filter history");
        this.setSize(364, 173);
        this.centreDialog();
        this.btnApply.requestFocus();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            jLabel2.setText("Pattern:");
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.insets = new Insets(5, 2, 5, 10);
            gridBagConstraints4.ipadx = 100;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.insets = new Insets(5, 2, 5, 2);
            jLabel.setText("<html><p>Enter the string below to filter requests/responses with matching string/pattern in history.  Regular expression is supported.</p></html>");
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(10, 10, 5, 10);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)jLabel2, gridBagConstraints5);
            this.jPanel.add((Component)this.getTxtPattern(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton();
            this.btnApply.setText("Apply");
            this.btnApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Pattern pattern = Pattern.compile(HistoryFilterDialog.this.getPattern());
                    }
                    catch (Exception exception) {
                        View.getSingleton().showWarningDialog("Invalid pattern.");
                        return;
                    }
                    HistoryFilterDialog.this.exitResult = 0;
                    HistoryFilterDialog.this.dispose();
                }
            });
        }
        return this.btnApply;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HistoryFilterDialog.this.exitResult = 2;
                    HistoryFilterDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JTextField getTxtPattern() {
        if (this.txtPattern == null) {
            this.txtPattern = new JTextField();
        }
        return this.txtPattern;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getBtnApply(), null);
            this.jPanel1.add((Component)this.getBtnReset(), null);
            this.jPanel1.add((Component)this.getBtnCancel(), null);
        }
        return this.jPanel1;
    }

    public int showDialog() {
        this.show();
        return this.exitResult;
    }

    public String getPattern() {
        String string = "";
        if (this.getRadioRegex().isSelected()) {
            string = this.getTxtPattern().getText();
        } else if (this.getRadioExact().isSelected()) {
            string = "\\Q" + this.getTxtPattern().getText() + "\\E";
        }
        return string;
    }

    private JButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new JButton();
            this.btnReset.setText("Reset filter");
            this.btnReset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HistoryFilterDialog.this.exitResult = 1;
                    HistoryFilterDialog.this.txtPattern.setText("");
                    HistoryFilterDialog.this.dispose();
                }
            });
        }
        return this.btnReset;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridLayout gridLayout = new GridLayout();
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(gridLayout);
            gridLayout.setRows(1);
            this.jPanel2.add((Component)this.getRadioExact(), null);
            this.jPanel2.add((Component)this.getRadioRegex(), null);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getRadioExact());
            buttonGroup.add(this.getRadioRegex());
        }
        return this.jPanel2;
    }

    private JRadioButton getRadioExact() {
        if (this.radioExact == null) {
            this.radioExact = new JRadioButton();
            this.radioExact.setText("Exact (case insensitive)");
            this.radioExact.setSelected(true);
        }
        return this.radioExact;
    }

    private JRadioButton getRadioRegex() {
        if (this.radioRegex == null) {
            this.radioRegex = new JRadioButton();
            this.radioRegex.setText("Regular expression");
        }
        return this.radioRegex;
    }
}

