/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.Model;

public class ReportLastScan {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAlertXML(Database database, RecordScan recordScan) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            connection = database.getDatabaseServer().getNewConnection();
            connection.setReadOnly(true);
            preparedStatement = connection.prepareStatement("SELECT ALERT.ALERTID FROM ALERT JOIN SCAN ON ALERT.SCANID = SCAN.SCANID WHERE SCAN.SCANID = ?");
            preparedStatement.setInt(1, recordScan.getScanId());
            preparedStatement.executeQuery();
            ResultSet resultSet = preparedStatement.getResultSet();
            RecordAlert recordAlert = null;
            Alert alert = null;
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                recordAlert = database.getTableAlert().read(n);
                alert = new Alert(recordAlert);
                stringBuffer.append(alert.toXML());
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return stringBuffer.toString();
    }

    public void generate(ViewDelegate viewDelegate, Model model) {
        StringBuffer stringBuffer = new StringBuffer(500);
        RecordScan recordScan = null;
        try {
            recordScan = model.getDb().getTableScan().getLatestScan();
            if (recordScan == null) {
                viewDelegate.showMessageDialog("Scanned result not found.  No report generated.");
                return;
            }
            stringBuffer.append("<?xml version=\"1.0\"?>");
            stringBuffer.append("<report>\r\n");
            stringBuffer.append("Report generated at " + ReportGenerator.getCurrentDateTimeString() + ".\r\n");
            stringBuffer.append(this.getAlertXML(model.getDb(), recordScan));
            stringBuffer.append("</report>");
            String string = model.getSession().getSessionFolder() + File.separator + "LatestScannedReport.htm";
            File file = ReportGenerator.stringToHtml(stringBuffer.toString(), "xml" + File.separator + "reportLatestScan.xsl", string);
            viewDelegate.showMessageDialog("Scanning report generated.  If it does not show up after clicking OK,\r\nplease browse the file at " + file.getAbsolutePath());
            ReportGenerator.openBrowser(file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            viewDelegate.showWarningDialog("File creation error.");
        }
    }
}

