/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.xml.sax.SAXException;

public class Model {
    private static Model model = null;
    private static final String DBNAME_TEMPLATE = "db/parosdb";
    private static final String DBNAME_UNTITLED = "session/untitled";
    private static int DBNAME_COPY = 1;
    private Session session = new Session(this);
    private OptionsParam optionsParam = new OptionsParam();
    private Database db = null;
    private String currentDBNameUntitled = "";

    public OptionsParam getOptionsParam() {
        if (this.optionsParam == null) {
            this.optionsParam = new OptionsParam();
        }
        return this.optionsParam;
    }

    public void setOptionsParam(OptionsParam optionsParam) {
        this.optionsParam = optionsParam;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = new Session(this);
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void init() throws SAXException, IOException, Exception {
        this.db = Database.getSingleton();
        this.createAndOpenUntitledDb();
        HistoryReference.setTableHistory(this.getDb().getTableHistory());
        this.getOptionsParam().readAndParseFile("xml/options.xml");
    }

    public static Model getSingleton() {
        if (model == null) {
            model = new Model();
        }
        return model;
    }

    public Database getDb() {
        return this.db;
    }

    public void moveSessionDb(String string) throws Exception {
        this.getDb().close();
        boolean bl = false;
        File file = new File(this.currentDBNameUntitled + ".data");
        File file2 = new File(this.currentDBNameUntitled + ".script");
        File file3 = new File(this.currentDBNameUntitled + ".properties");
        File file4 = new File(this.currentDBNameUntitled + ".backup");
        File file5 = new File(string + ".data");
        File file6 = new File(string + ".script");
        File file7 = new File(string + ".properties");
        File file8 = new File(string + ".backup");
        if (file5.exists()) {
            file5.delete();
        }
        if (file6.exists()) {
            file6.delete();
        }
        if (file7.exists()) {
            file7.delete();
        }
        if (file8.exists()) {
            file8.delete();
        }
        bl = file.renameTo(file5);
        bl = file2.renameTo(file6);
        bl = file3.renameTo(file7);
        if (file4.exists()) {
            bl = file4.renameTo(file8);
        }
        this.getDb().open(string);
    }

    public void copySessionDb(String string, String string2) throws Exception {
        this.getDb().close();
        FileCopier fileCopier = new FileCopier();
        File file = new File(string + ".data");
        File file2 = new File(string2 + ".data");
        fileCopier.copy(file, file2);
        File file3 = new File(string + ".script");
        File file4 = new File(string2 + ".script");
        fileCopier.copy(file3, file4);
        File file5 = new File(string + ".properties");
        File file6 = new File(string2 + ".properties");
        fileCopier.copy(file5, file6);
        File file7 = new File(string + ".backup");
        if (file7.exists()) {
            File file8 = new File(string2 + ".backup");
            fileCopier.copy(file7, file8);
        }
        this.getDb().open(string2);
    }

    public void createAndOpenUntitledDb() throws ClassNotFoundException, Exception {
        this.getDb().close();
        File file = new File("session");
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("untitled");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        this.currentDBNameUntitled = DBNAME_UNTITLED + DBNAME_COPY;
        FileCopier fileCopier = new FileCopier();
        File file2 = new File("db/parosdb.data");
        File file3 = new File(this.currentDBNameUntitled + ".data");
        file3.delete();
        fileCopier.copy(file2, file3);
        file2 = new File("db/parosdb.properties");
        file3 = new File(this.currentDBNameUntitled + ".properties");
        file3.delete();
        fileCopier.copy(file2, file3);
        file2 = new File("db/parosdb.script");
        file3 = new File(this.currentDBNameUntitled + ".script");
        file3.delete();
        fileCopier.copy(file2, file3);
        file2 = new File(this.currentDBNameUntitled + ".backup");
        if (file2.exists()) {
            file2.delete();
        }
        this.getDb().open(this.currentDBNameUntitled);
        ++DBNAME_COPY;
    }
}

