/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;

public class HttpMessage {
    private static Pattern staticPatternParam = Pattern.compile("&", 2);
    private HttpRequestHeader mReqHeader = new HttpRequestHeader();
    private HttpBody mReqBody = new HttpBody();
    private HttpResponseHeader mResHeader = new HttpResponseHeader();
    private HttpBody mResBody = new HttpBody();
    private Object userObject = null;

    public HttpMessage() {
    }

    public HttpMessage(HttpRequestHeader httpRequestHeader) {
        this.setRequestHeader(httpRequestHeader);
    }

    public HttpMessage(HttpRequestHeader httpRequestHeader, HttpBody httpBody) {
        this.setRequestHeader(httpRequestHeader);
        this.setRequestBody(httpBody);
    }

    public HttpMessage(HttpRequestHeader httpRequestHeader, HttpBody httpBody, HttpResponseHeader httpResponseHeader, HttpBody httpBody2) {
        this.setRequestHeader(httpRequestHeader);
        this.setRequestBody(httpBody);
        this.setResponseHeader(httpResponseHeader);
        this.setResponseBody(httpBody2);
    }

    public HttpMessage(String string, String string2, String string3, String string4) throws HttpMalformedHeaderException {
        this.setRequestHeader(string);
        this.setRequestBody(string2);
        if (string3 != null && !string3.equals("")) {
            this.setResponseHeader(string3);
            this.setResponseBody(string4);
        }
    }

    public HttpRequestHeader getRequestHeader() {
        return this.mReqHeader;
    }

    public void setRequestHeader(HttpRequestHeader httpRequestHeader) {
        this.mReqHeader = httpRequestHeader;
    }

    public HttpResponseHeader getResponseHeader() {
        return this.mResHeader;
    }

    public void setResponseHeader(HttpResponseHeader httpResponseHeader) {
        this.mResHeader = httpResponseHeader;
    }

    public HttpBody getRequestBody() {
        return this.mReqBody;
    }

    public void setRequestBody(HttpBody httpBody) {
        this.mReqBody = httpBody;
    }

    public HttpBody getResponseBody() {
        return this.mResBody;
    }

    public void setResponseBody(HttpBody httpBody) {
        this.mResBody = httpBody;
    }

    public void setRequestHeader(String string) throws HttpMalformedHeaderException {
        HttpRequestHeader httpRequestHeader = new HttpRequestHeader(string);
        this.setRequestHeader(httpRequestHeader);
    }

    public void setResponseHeader(String string) throws HttpMalformedHeaderException {
        HttpResponseHeader httpResponseHeader = new HttpResponseHeader(string);
        this.setResponseHeader(httpResponseHeader);
    }

    public void setRequestBody(String string) {
        this.getRequestBody().setBody(string);
    }

    public void setResponseBody(String string) {
        if (this.mReqBody == null) {
            this.mReqBody = new HttpBody(string);
        }
        this.getResponseBody().setBody(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpMessage)) {
            return false;
        }
        HttpMessage httpMessage = (HttpMessage)object;
        boolean bl = false;
        if (!this.getRequestHeader().getMethod().equalsIgnoreCase(httpMessage.getRequestHeader().getMethod())) {
            return false;
        }
        URI uRI = this.getRequestHeader().getURI();
        URI uRI2 = httpMessage.getRequestHeader().getURI();
        try {
            if (uRI.getHost() == null || uRI2.getHost() == null || !uRI.getHost().equalsIgnoreCase(uRI2.getHost())) {
                return false;
            }
            if (uRI.getPort() != uRI2.getPort()) {
                return false;
            }
            String string = uRI.getPathQuery();
            String string2 = uRI2.getPathQuery();
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null) {
                return string.equalsIgnoreCase(string2);
            }
            if (string == null || string2 == null) {
                return false;
            }
            if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
                return this.getRequestBody().toString().equalsIgnoreCase(httpMessage.getRequestBody().toString());
            }
            bl = true;
        }
        catch (URIException uRIException) {
            try {
                bl = this.getRequestHeader().getURI().toString().equalsIgnoreCase(httpMessage.getRequestHeader().getURI().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean equalType(HttpMessage httpMessage) {
        boolean bl = false;
        if (!this.getRequestHeader().getMethod().equalsIgnoreCase(httpMessage.getRequestHeader().getMethod())) {
            return false;
        }
        URI uRI = this.getRequestHeader().getURI();
        URI uRI2 = httpMessage.getRequestHeader().getURI();
        try {
            if (uRI.getHost() == null || uRI2.getHost() == null || !uRI.getHost().equalsIgnoreCase(uRI2.getHost())) {
                return false;
            }
            if (uRI.getPort() != uRI2.getPort()) {
                return false;
            }
            String string = uRI.getPath();
            String string2 = uRI2.getPath();
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null && !string.equalsIgnoreCase(string2)) {
                return false;
            }
            if (string == null || string2 == null) {
                return false;
            }
            if (!this.queryEquals(httpMessage)) {
                return false;
            }
            bl = true;
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        return bl;
    }

    private boolean queryEquals(HttpMessage httpMessage) throws URIException {
        boolean bl = false;
        URI uRI = this.getRequestHeader().getURI();
        URI uRI2 = httpMessage.getRequestHeader().getURI();
        String string = "";
        String string2 = "";
        TreeSet treeSet = null;
        TreeSet treeSet2 = null;
        if (uRI.getQuery() != null) {
            string = uRI.getQuery();
        }
        if (uRI2.getQuery() != null) {
            string2 = uRI2.getQuery();
        }
        if (!((Object)(treeSet = this.getParamNameSet(string))).equals(treeSet2 = this.getParamNameSet(string2))) {
            return false;
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            string = this.getRequestBody().toString();
            string2 = httpMessage.getRequestBody().toString();
            treeSet = this.getParamNameSet(string);
            if (!((Object)treeSet).equals(treeSet2 = this.getParamNameSet(string2))) {
                return false;
            }
        }
        bl = true;
        return bl;
    }

    public TreeSet getParamNameSet(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = staticPatternParam.split(string);
        String string2 = null;
        String string3 = null;
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = null;
            string3 = null;
            n = stringArray[i].indexOf(61);
            try {
                if (n > 0) {
                    string2 = stringArray[i].substring(0, n);
                    string3 = stringArray[i].substring(n + 1);
                }
                treeSet.add(string2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return treeSet;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public HttpMessage cloneAll() {
        HttpMessage httpMessage = this.cloneRequest();
        if (!this.getResponseHeader().isEmpty()) {
            try {
                httpMessage.getResponseHeader().setMessage(this.getResponseHeader().toString());
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                // empty catch block
            }
            httpMessage.getResponseBody().setBody(this.getResponseBody().toString());
        }
        return httpMessage;
    }

    public HttpMessage cloneRequest() {
        HttpMessage httpMessage = new HttpMessage();
        if (!this.getRequestHeader().isEmpty()) {
            try {
                httpMessage.getRequestHeader().setMessage(this.getRequestHeader().toString());
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                // empty catch block
            }
            httpMessage.getRequestBody().setBody(this.getRequestBody().toString());
        }
        return httpMessage;
    }
}

