/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpResponseHeader;

public class HttpOutputStream {
    private static final String CODEPAGE = "8859_1";
    private static final String CRLF2 = "\r\n\r\n";
    private static final String LF2 = "\n\n";
    private BufferedOutputStream out = null;

    public HttpOutputStream(OutputStream outputStream) {
        this.out = new BufferedOutputStream(outputStream);
    }

    public void write(String string) throws IOException {
        this.out.write(string.getBytes(CODEPAGE));
        this.flush();
    }

    public void write(HttpBody httpBody) throws IOException {
        if (httpBody != null && httpBody.length() > 0) {
            this.write(httpBody.toString().getBytes(CODEPAGE));
        }
    }

    public void write(HttpResponseHeader httpResponseHeader) throws IOException {
        this.write(httpResponseHeader.toString());
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return;
        }
        this.out.write(byArray, n, n2);
        this.flush();
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

