/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class HttpRequestHeader
extends HttpHeader {
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String CONNECT = "CONNECT";
    public static final String HOST = "Host";
    private static final Pattern patternRequestLine = Pattern.compile("(\\w+) +(\\S+) +(HTTP/\\d+\\.\\d+)", 2);
    private static final Pattern patternHostHeader = Pattern.compile("([^:]+)\\s*?:?\\s*?(\\d*?)");
    private static final Pattern patternImage = Pattern.compile("\\.(jpg|jpeg|gif|tiff|tif|png)\\z", 2);
    private static final Pattern patternPartialRequestLine = Pattern.compile("\\A *(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT)\\b", 2);
    private String mMethod = "";
    private URI mUri = null;
    private String mHostName = "";
    private int mHostPort = 80;
    private boolean mIsSecure = false;

    public HttpRequestHeader() {
        this.mMsgHeader = "";
    }

    public HttpRequestHeader(String string, boolean bl) throws HttpMalformedHeaderException {
        this();
        this.setMessage(string, bl);
    }

    public HttpRequestHeader(String string) throws HttpMalformedHeaderException {
        this();
        this.setMessage(string);
    }

    public HttpRequestHeader(String string, URI uRI) throws HttpMalformedHeaderException {
        this(string + " " + uRI.toString() + " " + "HTTP/1.1" + "\r\n" + "\r\n");
        try {
            this.setHeader(HOST, uRI.getHost() + (uRI.getPort() > 0 ? ":" + Integer.toString(uRI.getPort()) : ""));
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        this.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)");
        this.setHeader("Pragma", "no-cache");
        this.setHeader("Accept-Encoding", null);
        this.setContentLength(0);
    }

    public void setMessage(String string, boolean bl) throws HttpMalformedHeaderException {
        super.setMessage(string);
        try {
            if (!this.parse(bl)) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception exception) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public void setMessage(String string) throws HttpMalformedHeaderException {
        this.setMessage(string, false);
    }

    public String getMethod() {
        return this.mMethod;
    }

    public void setMethod(String string) {
        this.mMethod = string.toUpperCase();
    }

    public URI getURI() {
        return this.mUri;
    }

    public void setURI(URI uRI) throws URIException, NullPointerException {
        this.mUri = uRI.getScheme() == null || uRI.getScheme().equals("") ? new URI("http://" + this.getHeader(HOST) + "/" + this.mUri.toString(), true) : uRI;
        this.mIsSecure = uRI.getScheme().equalsIgnoreCase("https");
    }

    public boolean getSecure() {
        return this.mIsSecure;
    }

    public void setSecure(boolean bl) throws URIException, NullPointerException {
        this.mIsSecure = bl;
        if (this.mUri == null) {
            return;
        }
        if (this.getSecure() && this.mUri.getScheme().equalsIgnoreCase("http")) {
            this.mUri = new URI(this.mUri.toString().replaceFirst("http", "https"), true);
            return;
        }
        if (!this.getSecure() && this.mUri.getScheme().equalsIgnoreCase("https")) {
            this.mUri = new URI(this.mUri.toString().replaceFirst("https", "http"), true);
            return;
        }
    }

    public void setVersion(String string) {
        this.mVersion = string.toUpperCase();
    }

    public int getContentLength() {
        if (this.mContentLength == -1) {
            return 0;
        }
        return this.mContentLength;
    }

    protected boolean parse(boolean bl) throws URIException, NullPointerException {
        this.mIsSecure = bl;
        Matcher matcher = patternRequestLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            return false;
        }
        this.mMethod = matcher.group(1);
        String string = matcher.group(2);
        this.mVersion = matcher.group(3);
        if (!(this.mVersion.equalsIgnoreCase("HTTP/0.9") || this.mVersion.equalsIgnoreCase("HTTP/1.0") || this.mVersion.equalsIgnoreCase("HTTP/1.1"))) {
            this.mMalformedHeader = true;
            return false;
        }
        this.mUri = new URI(string, true);
        if (this.mUri.getScheme() == null || this.mUri.getScheme().equals("")) {
            this.mUri = new URI("http://" + this.getHeader(HOST) + this.mUri.toString(), true);
        }
        if (this.getSecure() && this.mUri.getScheme().equalsIgnoreCase("http")) {
            this.mUri = new URI(this.mUri.toString().replaceFirst("http", "https"), true);
        }
        if (this.mUri.getScheme().equalsIgnoreCase("https")) {
            this.setSecure(true);
        }
        String string2 = null;
        if (this.mMethod.equalsIgnoreCase(CONNECT)) {
            string2 = string;
            this.parseHostName(string2);
        } else {
            this.mHostName = this.mUri.getHost();
            this.mHostPort = this.mUri.getPort();
        }
        return true;
    }

    private void parseHostName(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        n = string.indexOf(58, 2);
        if (n > -1) {
            this.mHostName = string.substring(0, n).trim();
            try {
                this.mHostPort = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.mHostName = string.trim();
        }
    }

    public String getHostName() {
        String string = this.mHostName;
        try {
            string = this.mUri.getHost();
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        return string;
    }

    public int getHostPort() {
        int n = this.mUri.getPort();
        return n;
    }

    public boolean isImage() {
        try {
            return patternImage.matcher(this.getURI().getPath()).find();
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
            return false;
        }
    }

    public static boolean isRequestLine(String string) {
        return patternPartialRequestLine.matcher(string).find();
    }

    public String getPrimeHeader() {
        return this.getMethod() + " " + this.getURI().toString() + " " + this.getVersion();
    }
}

