/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.view.AbstractParamPanel;

public class OptionsConnectionPanel
extends AbstractParamPanel {
    private static final String[] ROOT = new String[0];
    private JCheckBox chkUseProxyChain = null;
    private JPanel jPanel = null;
    private JPanel panelProxyAuth = null;
    private JScrollPane jScrollPane = null;
    private OptionsParam optionsParam = null;
    private JPanel panelProxyChain = null;
    private JTextField txtProxyChainName = null;
    private JTextField txtProxyChainPort = null;
    private JTextArea txtProxyChainSkipName = null;
    private JTextField txtProxyChainRealm = null;
    private JTextField txtProxyChainUserName = null;
    private JTextField txtProxyChainPassword = null;
    private JCheckBox chkProxyChainAuth = null;

    public OptionsConnectionPanel() {
        this.initialize();
    }

    private JCheckBox getChkUseProxyChain() {
        if (this.chkUseProxyChain == null) {
            this.chkUseProxyChain = new JCheckBox();
            this.chkUseProxyChain.setText("Use an outgoing proxy server");
            this.chkUseProxyChain.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsConnectionPanel.this.setProxyChainEnabled(OptionsConnectionPanel.this.chkUseProxyChain.isSelected());
                }
            });
        }
        return this.chkUseProxyChain;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            jLabel3.setText("Address/Domain Name:");
            jLabel2.setText("Port (eg 8080):");
            jLabel.setText("<html><p>Skip IP address or domain names below (* for wildcard characters, names separate by ;):</p></html>");
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.weightx = 0.5;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.5;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.ipadx = 50;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 0.5;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.ipadx = 50;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.anchor = 12;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.ipady = 20;
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, "Use proxy chain", 0, 0, null, null));
            this.jPanel.add((Component)this.getChkUseProxyChain(), gridBagConstraints7);
            this.jPanel.add((Component)jLabel3, gridBagConstraints6);
            this.jPanel.add((Component)this.getTxtProxyChainName(), gridBagConstraints5);
            this.jPanel.add((Component)jLabel2, gridBagConstraints4);
            this.jPanel.add((Component)this.getTxtProxyChainPort(), gridBagConstraints3);
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getPanelProxyAuth() {
        if (this.panelProxyAuth == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            this.panelProxyAuth = new JPanel();
            this.panelProxyAuth.setLayout(new GridBagLayout());
            jLabel3.setText("Realm:");
            jLabel2.setText("User name:");
            jLabel.setText("Password (stored in clear-text):");
            this.panelProxyAuth.setBorder(BorderFactory.createTitledBorder(null, "Proxy authentication", 0, 0, new Font("Dialog", 0, 11), Color.black));
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.weightx = 0.5;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.5;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.ipadx = 50;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 0.5;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.ipadx = 50;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.ipadx = 50;
            this.panelProxyAuth.add((Component)this.getChkProxyChainAuth(), gridBagConstraints7);
            this.panelProxyAuth.add((Component)jLabel3, gridBagConstraints6);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainRealm(), gridBagConstraints5);
            this.panelProxyAuth.add((Component)jLabel2, gridBagConstraints4);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainUserName(), gridBagConstraints3);
            this.panelProxyAuth.add((Component)jLabel, gridBagConstraints2);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainPassword(), gridBagConstraints);
        }
        return this.panelProxyAuth;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtProxyChainSkipName());
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.jScrollPane;
    }

    private JPanel getPanelProxyChain() {
        if (this.panelProxyChain == null) {
            this.panelProxyChain = new JPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.panelProxyChain.setLayout(new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            this.panelProxyChain.setName("Proxy Chain");
            jLabel.setText("");
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            this.panelProxyChain.add((Component)this.getJPanel(), gridBagConstraints);
            this.panelProxyChain.add((Component)this.getPanelProxyAuth(), gridBagConstraints2);
            this.panelProxyChain.add((Component)jLabel, gridBagConstraints3);
        }
        return this.panelProxyChain;
    }

    private JTextField getTxtProxyChainName() {
        if (this.txtProxyChainName == null) {
            this.txtProxyChainName = new JTextField();
        }
        return this.txtProxyChainName;
    }

    private JTextField getTxtProxyChainPort() {
        if (this.txtProxyChainPort == null) {
            this.txtProxyChainPort = new JTextField();
        }
        return this.txtProxyChainPort;
    }

    private JTextArea getTxtProxyChainSkipName() {
        if (this.txtProxyChainSkipName == null) {
            this.txtProxyChainSkipName = new JTextArea();
            this.txtProxyChainSkipName.setFont(new Font("Dialog", 0, 11));
        }
        return this.txtProxyChainSkipName;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName("Connection");
        this.add((Component)this.getPanelProxyChain(), this.getPanelProxyChain().getName());
    }

    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        ConnectionParam connectionParam = optionsParam.getConnectionParam();
        if (connectionParam.getProxyChainName().equals("")) {
            this.chkUseProxyChain.setSelected(false);
            this.setProxyChainEnabled(false);
        } else {
            this.chkUseProxyChain.setSelected(true);
            this.setProxyChainEnabled(true);
            this.txtProxyChainName.setText(connectionParam.getProxyChainName());
            this.txtProxyChainPort.setText(Integer.toString(connectionParam.getProxyChainPort()));
            this.txtProxyChainSkipName.setText(connectionParam.getProxyChainSkipName());
            if (connectionParam.getProxyChainUserName().equals("")) {
                this.chkProxyChainAuth.setSelected(false);
                this.setProxyChainAuthEnabled(false);
            } else {
                this.chkProxyChainAuth.setSelected(true);
                this.setProxyChainAuthEnabled(true);
                this.txtProxyChainRealm.setText(connectionParam.getProxyChainRealm());
                this.txtProxyChainUserName.setText(connectionParam.getProxyChainUserName());
                this.txtProxyChainPassword.setText(connectionParam.getProxyChainPassword());
            }
        }
    }

    private void setProxyChainEnabled(boolean bl) {
        this.txtProxyChainName.setEnabled(bl);
        this.txtProxyChainPort.setEnabled(bl);
        this.txtProxyChainSkipName.setEnabled(bl);
        this.chkProxyChainAuth.setEnabled(bl);
        Color color = Color.WHITE;
        if (!bl) {
            this.txtProxyChainName.setText("");
            this.txtProxyChainPort.setText("");
            this.txtProxyChainSkipName.setText("");
            this.chkProxyChainAuth.setSelected(false);
            this.setProxyChainAuthEnabled(false);
            color = this.panelProxyChain.getBackground();
        }
        this.txtProxyChainName.setBackground(color);
        this.txtProxyChainPort.setBackground(color);
        this.txtProxyChainSkipName.setBackground(color);
    }

    private void setProxyChainAuthEnabled(boolean bl) {
        this.txtProxyChainRealm.setEnabled(bl);
        this.txtProxyChainUserName.setEnabled(bl);
        this.txtProxyChainPassword.setEnabled(bl);
        Color color = Color.WHITE;
        if (!bl) {
            this.txtProxyChainRealm.setText("");
            this.txtProxyChainUserName.setText("");
            this.txtProxyChainPassword.setText("");
            color = this.panelProxyChain.getBackground();
        }
        this.txtProxyChainRealm.setBackground(color);
        this.txtProxyChainUserName.setBackground(color);
        this.txtProxyChainPassword.setBackground(color);
    }

    public void validateParam(Object object) throws Exception {
        int n = 8080;
        if (this.chkUseProxyChain.isSelected()) {
            try {
                n = Integer.parseInt(this.txtProxyChainPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.txtProxyChainPort.requestFocus();
                throw new Exception("Invalid proxy chain port number.");
            }
        }
    }

    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        ConnectionParam connectionParam = optionsParam.getConnectionParam();
        int n = 8080;
        if (this.chkUseProxyChain.isSelected()) {
            try {
                n = Integer.parseInt(this.txtProxyChainPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.txtProxyChainPort.requestFocus();
                throw new Exception("Invalid proxy chain port number.");
            }
        }
        connectionParam.setProxyChainName(this.txtProxyChainName.getText());
        connectionParam.setProxyChainPort(n);
        connectionParam.setProxyChainSkipName(this.txtProxyChainSkipName.getText());
        connectionParam.setProxyChainRealm(this.txtProxyChainRealm.getText());
        connectionParam.setProxyChainUserName(this.txtProxyChainUserName.getText());
        connectionParam.setProxyChainPassword(this.txtProxyChainPassword.getText());
    }

    private JTextField getTxtProxyChainRealm() {
        if (this.txtProxyChainRealm == null) {
            this.txtProxyChainRealm = new JTextField();
        }
        return this.txtProxyChainRealm;
    }

    private JTextField getTxtProxyChainUserName() {
        if (this.txtProxyChainUserName == null) {
            this.txtProxyChainUserName = new JTextField();
        }
        return this.txtProxyChainUserName;
    }

    private JTextField getTxtProxyChainPassword() {
        if (this.txtProxyChainPassword == null) {
            this.txtProxyChainPassword = new JTextField();
        }
        return this.txtProxyChainPassword;
    }

    private JCheckBox getChkProxyChainAuth() {
        if (this.chkProxyChainAuth == null) {
            this.chkProxyChainAuth = new JCheckBox();
            this.chkProxyChainAuth.setText("Outgoing proxy server requires authentication");
            this.chkProxyChainAuth.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsConnectionPanel.this.setProxyChainAuthEnabled(OptionsConnectionPanel.this.chkProxyChainAuth.isSelected());
                }
            });
        }
        return this.chkProxyChainAuth;
    }
}

