package fx.ChaiCrack;
/*
* Copyright Hewlett-Packard Company 1997 All rights reserved
* This file may be copied, modified and distributed only in
* accordance with the terms of the limited licence contained
* in the accompanying file LICENSE.
*/

import hp.chaiserver.*;
import java.io.*;

public final class ChaiCrackStub extends Worker implements IWorker {

	private final String DISCOVERPROPS = new String("__DISCOVERPROPS");
	public final String WORKER_VERSION = "ChaiServer.3.0.0.0";
	private final static String CRACKIT	= new String("CrackIt");
	private final static String KILLTHREAD	= new String("KillThread");
	private final static String ABOUTPAGE	= new String("aboutPage");

	// Helper methods for worker
	protected Object createObject() {
		return (Object) new ChaiCrackImpl();
	}

	protected String getObjectClassName() {
		return new String("ChaiCrackImpl");
	}

	protected boolean invokeMethod(Object obj, String method, String format)
		throws Exception {
		ChaiCrackImpl cs_obj = (ChaiCrackImpl) obj;

		if(method.equalsIgnoreCase(DISCOVERPROPS)) {
			webProtocol.sendToClient("HTTP/1.1 200 OK\r\n");
			webProtocol.sendToClient("MIME-Version: 1.0\r\n");
			webProtocol.sendToClient("Server: HP/ChaiServer 3.0\r\n");
			webProtocol.sendToClient("Content-type: text/plain\r\n\n");
			webProtocol.sendToClient("CrackIt,KillThread,aboutPage");
			return true;
		}
		if (method.equalsIgnoreCase(CRACKIT))
			cs_obj.CrackIt(format, args, reqEnv);

		else if (method.equalsIgnoreCase(KILLTHREAD))
			cs_obj.KillThread(format, args, reqEnv);

		else if (method.equalsIgnoreCase(ABOUTPAGE))
			cs_obj.aboutPage(format, args, reqEnv);
		else
			return false;

		return true;
	}

	protected boolean isObjectInstance(Object obj) {
		return (obj instanceof ChaiCrackImpl);
	}

	// Methods callable outside of worker
	public String getVersion() {
		return WORKER_VERSION;
	}

}

