package fx.Cps;

import java.io.*;
import java.net.*;
import hp.chaiserver.*;
import fx.Cps.*;

/* 
 * $Id: CpsImpl.java,v 1.8 2002/04/29 17:49:52 fx Exp fx $
 */
public class CpsImpl extends Thread implements ICps, IChaiServer {
    private java.lang.Thread	scannert;
    private InetAddress		ta;
    private int			port_start;
    private int			port_stop;

    /* initWorkerArgs is defined in hp.chaiserver.IChaiServer and obviously
     * has to be overloaded by the service ... 
     * It's called when the ChaiService intializes */
    public void initWorkerArgs(String name, IDaemon daemon, ArgVector args) {
	scannert=null;
	port_start=1;
	port_stop=1024;
    }


    /* homePage comes from the same source as hp.chaiserver.IChaiServer and 
     * is called for displaying the home page of the Service
     */
    public void homePage(OutputStream out, Environment env) {
	HTMLHelper html = (HTMLHelper) env.getHTMLHelper();

	HTMLStatus err = env.getErrResponder();

	try {
	    html.startHTMLDoc();

	    if ((scannert!=null) && (scannert.isAlive())) {
		html.sendData(
			"<H1>Phenoelit ChaiPortScanner (plus send)</H1>"
			+"<b>$Revision: 1.8 $ - DEBUG BUILD</b><br>"
			+"<i>the service already scans host "
			+ta.getHostAddress()
			+".</i><br>"
			+"You may terminate this scan:"
			+"<form method=\"GET\" action=\"/hp/device/fx.cps\">"
			+"<input type=hidden name=\"KillScan\" value=\"html\">"
			+"<input type=submit value=\"Kill\">"
			+"</form>");
		//System.out.println("DEBUG: ScanHost(): Scanner already running");
	    } else {
		html.sendData(
			"<H1>Phenoelit ChaiPortScanner</H1>"
			+"<b>$Revision: 1.8 $ - DEBUG BUILD</b>"
			+"<form method=\"GET\" action=\"/hp/device/fx.cps\">"
			+"<input type=hidden name=\"ScanHost\" value=\"html\">"
			+"<input type=text size=30 name=\"target\"><br>"
			+"Start port: "
			+"<input type=text size=5  name=\"sport\" value=\"1\">"
			+"End port: "
			+"<input type=text size=5  name=\"eport\" value=\"1024\">"
			+"<br>"
			+"<input type=submit value=\"Scan!\">"
			+"</form>"); 
	    }

	    html.startTag("HR");
	    html.addMethodLink("fx.cps","aboutPage",null,"About",null);
	    html.endHTMLDoc();
	} catch (IOException ioe) {
	    err.sendException("IOException: ",ioe);
	}
    }

    /* 
     * Kill the running scanner
     *
     */
    public void KillScan(String retFormat, ArgVector args, Environment env) {
	HTMLHelper html = (HTMLHelper) env.getHTMLHelper();
	HTMLStatus err = env.getErrResponder();

	//System.out.println("DEBUG: KillScan() started");

	// output try branch
	try {
	    html.startHTMLDoc();

	    if ((scannert!=null) && (scannert.isAlive())) {
		//System.out.println("DEBUG: ScanHost(): killing Scanner");
		scannert.stop();
		html.sendData("Killed the scan as requested. "
			+"You may <a href=\"/hp/device/fx.cps\">return</a>"
			+" to the homepage now");
		//System.out.println("DEBUG: ScanHost(): Scanner killed");
	    } else {
		html.sendData("<b>Scanner is not running!</b>");
		//System.out.println("DEBUG: ScanHost(): Scanner not running");
	    }

	    html.endHTMLDoc();
	} catch (IOException ioe) {
	    err.sendException("IOException: ",ioe);
	}

	return;
    }

    /* 
     * Let's see if this works out
     *
     */
    public void ScanHost(String retFormat, ArgVector args, Environment env) {
	HTMLHelper html = (HTMLHelper) env.getHTMLHelper();
	HTMLStatus err = env.getErrResponder();
	InetAddress addr = null;

	//System.out.println("DEBUG: ScanHost() started");

	// get the target selected
	String target = args.getArg("target");
	if (target == null) {
	    err.sendError(400,"Not enough arguments."
		    +"What do you think should I scan?");
	    return;
	}

	String sport = args.getArg("sport");
	if (sport == null) {
	    err.sendError(400,"Not enough arguments."
		    +"Start port?");
	    return;
	}
	Integer isport = new Integer(sport);
	if ((isport.intValue()<=0) || (isport.intValue()>65535)) {
	    err.sendError(400,"Invalid arguments."
		    +"Start port?");
	    return;
	}

	String eport = args.getArg("eport");
	if (sport == null) {
	    err.sendError(400,"Not enough arguments."
		    +"End port?");
	    return;
	}
	Integer ieport = new Integer(eport);
	if ((ieport.intValue()<=0) || (ieport.intValue()>65535)) {
	    err.sendError(400,"Invalid arguments."
		    +"End port?");
	    return;
	}
	if (isport.intValue()>ieport.intValue()) {
	    err.sendError(400,"Invalid arguments."
		    +"Start port really should be lower than end port");
	    return;
	}

	// get the IP address of it if possible
	try {
	    addr=InetAddress.getByName(target);
	} catch (UnknownHostException e) {
	    err.sendError(400,"Could not resolve host");
	    return;
	}

	//System.out.println("DEBUG: ScanHost(): IP address resolved");

	// output try branch
	try {
	    html.startHTMLDoc();

	    if ((scannert!=null) && (scannert.isAlive())) {
		html.sendData("<i>Sorry, according to my information"+
			", the service already scans host"+
			ta.getHostAddress()+
			".<br>"+
			"Please try later</i>");
		//System.out.println("DEBUG: ScanHost(): Scanner already running");
	    } else {
		html.sendData("<b>Staring scanner for "+target+
			"</b><br>"+
			"Please come back in a while and check the file");
		//System.out.println("DEBUG: ScanHost(): starting Scanner");
		RunScanner(addr,isport.intValue(),ieport.intValue());
	    }

	    html.endHTMLDoc();
	} catch (IOException ioe) {
	    err.sendException("IOException: ",ioe);
	}
    }

    /*
     * 		Scanner Thread 
     */

    public void RunScanner(InetAddress ta, int sport, int eport) {
	this.ta=ta;
	this.port_start=sport;
	this.port_stop=eport;
	//System.out.println("DEBUG: RunScanner(): making new Thread");
	scannert = new java.lang.Thread(this);
	//scannert.parent=this;
	//System.out.println("DEBUG: RunScanner(): setting daemon");
	scannert.setDaemon(true);
	//System.out.println("DEBUG: RunScanner(): setting name");
	scannert.setName("CPSdaemon");
	//System.out.println("DEBUG: RunScanner(): starting Thread");
	scannert.start();
    }

    public void run() {
	//String	filename = "/tmp/result.test";
	String	filename = "0:\\result.txt";
	Thread	portsc;

	//System.out.println("DEBUG: run(): starting for loop");
	for (int port=port_start; port<=port_stop; port++) {
	    //System.out.println("DEBUG: run(): making new scanPort()");
	    portsc=new scanPort(ta,port,filename);
	    //System.out.println("DEBUG: run(): starting new scanPort("+port+")");
	    portsc.start();
	    try {
		sleep(5000);
	    } catch (InterruptedException e) {}
	    if (portsc.isAlive()) { 
		portsc.stop();
	    }
	}
	//System.out.println("DEBUG: run(): killing myself");
	stop();
    }

    /* ************************************************** */

    /*
     * Totally useless About Page .. but what the heck 
     */
    public void aboutPage(String retFormat, ArgVector args, Environment env) {
	HTMLHelper html = (HTMLHelper) env.getHTMLHelper();
	HTMLStatus err = env.getErrResponder();

	try {
	    html.sendText("Phenoelit CPS1 ... cool, eh?");
	} catch (IOException ioe) {
	    err.sendException("IOException: ",ioe);
	}
    }


    /* exportMethods again comes from the IChaiServer package and provides
     * the caller with a list of export methods (no idea what they mean by
     * that right now).
     */
    public void exportMethods(OutputStream out, String str, Environment env) {
	HTMLHelper html = (HTMLHelper) env.getHTMLHelper();
	HTMLStatus err = env.getErrResponder();

	try {
	    html.sendText("export methods?");
	} catch (IOException ioe) {
	    err.sendException("IOException: ",ioe);
	}
    }

}
