/* Phenoelit's K0LD
 *
 * $Id: ldapa.h,v 1.5 2000/11/30 08:28:47 fx Exp fx $
 */
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>

#include <portable.h>

#include <ac/ctype.h>
#include <ac/signal.h>
#include <ac/socket.h>
#include <ac/string.h>
#include <ac/time.h>
#include <ac/unistd.h>

#include <lber.h>
#include <ldap.h>
#include <ldif.h>

#define PROJECT_NAME "K0LD"
#define PROJECT_TRANSLATION "Knocking On Ldap's Door"
#define MAJOR_VERSION 1
#define MINOR_VERSION 3

#define HOSTNAME "localhost"
#define PORTNUMBER 389
#define SCOPE LDAP_SCOPE_SUBTREE
#define FILTER "(uid=*)"

struct configuration {
	int	info,verbose,test_only;
	char	*basedn,*ldaphost;
	unsigned int	ldapport;
	char	*wordlist; 
	char	*filter;
	int	reopen;
	char	*resfile;

	/* win2k patches */
	char	*initial_bind;
	char	*initial_password;
	char	*dnlist;
};

int try_wordlist(char *dn,struct configuration c);
void scan_dnlist(struct configuration c);
void usage(char *pname);
void info(void);
