/************************************************************************/
/*                                                                      */
/* Sentry - Port Scan Detector Include File                             */
/*                                                                      */
/* Author: Craig H. Rowland <crowland@psionic.com>                      */
/*                          <crowland@bipolar.net>                      */
/* Created: 10-12-97                                                    */
/* Modified: 05-25-98                                                   */
/*                                                                      */
/* Send all changes/modifications/bugfixes to the above addresses.      */
/*                                                                      */
/*                                                                      */
/* This software is Copyright(c) 1997-98 Craig H. Rowland               */
/*                                                                      */
/* Disclaimer:								*/
/*									*/
/* All software distributed by Craig H. Rowland ("the author") and	*/
/* Psionic Systems is distributed AS IS and carries NO WARRANTY or	*/
/* GUARANTEE OF ANY KIND. End users of the software acknowledge that	*/
/* they will not hold the author, Psionic Systems, and any employer of	*/
/* the author liable for failure or non-function of a software		*/
/* product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK			*/
/*									*/
/* Licensing restrictions apply. See the license that came with this	*/
/* file for more information or visit http://www.psionic.com for more	*/
/* information.								*/
/*                                                                      */
/* Id: $Id: sentry.h,v 1.16 1998/05/28 13:19:14 crowland Exp crowland $	*/
/************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h> 
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <netdb.h>

#ifdef SUPPORT_STEALTH
#include <netinet/in_systm.h>

#ifdef LINUX
#define __USE_BSD 1
#define __FAVOR_BSD 1
/* Linux IP/TCP/UDP headers */
#include "sentry_tcpip.h"
#endif

#ifndef LINUX
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#endif

#endif /* SUPPORT_STEALTH */

#ifdef NEXT
#include <ansi.h>
#endif


#define ERROR -1
#define TRUE 1
#define FALSE 0
#define MAXBUF 1024
/* max size of an IP address plus NULL */
#define IPMAXBUF 17
/* max sockets we can open */
#define MAXSOCKS 64

/* RFC Spec */
#define DNSMAXBUF 255

#define VERSION "0.61"

/* prototypes */

extern int abacusWriteBlocked(char *, char *, int);
extern void abacusLog(char *);
extern void abacusExit(int);
extern void abacusStart(void);
extern int abacusDaemonSeed(void);
extern int abacusNeverBlock(char *);
extern int abacusCheckConfig(void);
extern int abacusOpenTCPSocket(void);
extern int abacusOpenUDPSocket(void);
extern int abacusBindSocket(int , struct sockaddr_in , struct sockaddr_in , int );
extern int abacusKillRoute(char *);
extern int abacusKillHostsDeny(char *);
extern int abacusKillRunCmd(char *);
extern int abacusConfigTokenRetrieve(char *, char *);
extern int abacusIsBlocked(char *);
extern int abacusSubstString(char *, char *, char *);
extern int abacusDoBlockUDP(void);
extern int abacusDoBlockTCP(void);

int sentryModeTCP(void);
int sentryModeUDP(void);
#ifdef SUPPORT_STEALTH
int sentryStealthModeTCP(void);
int sentryAdvancedStealthModeTCP(void);
int sentryStealthModeUDP(void);
int sentryAdvancedStealthModeUDP(void);
#endif
int disposeUDP(char *);
int disposeTCP(char *);
int checkStateEngine(char *);
void usage(void);

