/*
*   Copyright (C) 2000 PROTOS Project Consortium
*   [http://www.ee.oulu.fi/research/ouspg/protos]
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2
*   as published by  the Free Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package FI.protos.ouspg.wrapper;

import FI.protos.ouspg.wrapper.BugCat_ext;

import java.io.*;
import java.net.*;
import java.util.jar.*;
import java.lang.reflect.*;

/**
 * A TCP ServerSocket BugCat.
 */
public class ServerSocketTCPBugCat extends BugCat_ext {
    
    /**
     * Protected class to act as a server socket.
    */
    protected ServerSocket serverSocket = null;

    /**
     * Protected variable port to hold the server port. It now
     * defaults to 8000.
    */
    protected int port = 8000;

    /**
     * Protected variable cdelay to hold the time in milliseconds
     * before socket.close() is executed after injection.
     * defaults to 0 milliseconds.
    */
    protected int cdelay = 0;
  
    /**
     * Protected "constant" to hold the HTTP_HEADER. This header is
     * added to the "raw" test packet generated by the bugbear.
    */
    protected final String HTTP_HEADER = new String (
			"HTTP/1.1 200 OK\n" +
			"Server: Bugbear 020\n" +
			"Connection: Close \n" +
			"Content-Type: application/vnd.wap.wmlc\n\n");
    
    /**
     * Protected flag used to decide if content length is added to
     * HTTP header.
    */
    protected boolean contentlengthFlag = false;


    /**
     * Commando-line help.
    */
    public void help () {
	/* Overriden help method from superclas */
	System.out.println("Usage java -jar <jarfile>.jar [ [OPTIONS] ]\n"  +
			   "  -closedelay <millisec>  delay before"         +
			   " closing socket. Defaults to " + cdelay + "\n"  +
	                   "  -file <file>            Send file <file> "    +
			   "instead of testcase(s)\n"                       +
			   "  -help                   Display this help\n"  +
			   "  -jarfile <file>         Get data from "       +
			   "alternate bugcat JAR-file <file>\n"             +
			   "  -port <index>           Portnumber to listen" +
			   " connections from terminal/gw.\n"               +
			   "                          Defaults to " + port  +
			   "\n  -single <index>         "                   +
			   "Inject single test case <index>\n"      +
			   "  -start <index>          Inject test " +
			   "cases starting from <index>\n"                  +
			   "  -stop <index>           Stop test case "      +
			   "injecting to <index>\n");
	System.exit(0);
    }
  
    /**
     * Stub for Commando-line help. Activated by -h command line option
    */
    public void h () {
	this.help();
	System.exit(0);
    }

    /**
     * Port command line option. Defaults to 8000.
    */
    /**
     * Set port number by command line option '-port'.
     * @param portnumber The port number.
    */
    public void port (String portnumber) {
	try {
	    port = new Integer(portnumber).intValue();
	} catch (NumberFormatException e) {
	    System.out.println("Error: Invalid port number: " + portnumber);
	    System.exit(0);
	}
    }

    /**
     * Closedelay command line option. Defaults to 0.
    */
    /**
     * Set closedelay by command line option '-closedelay'.
     * @param closedelay. Closedelay in milliseconds.
    */
    public void closedelay (String closedelay) {
	try {
	    cdelay = new Integer(closedelay).intValue();
	} catch (NumberFormatException e) {
	    System.out.println("Error: Invalid closedelay: " + closedelay);
	    System.exit(0);
	}
    }

    
    /**
     * Main routine, parses command-line arguments and starts injection.
     * @param args Command-line arguments.
    */
    public static void main (String args[]) {
	ServerSocketTCPBugCat cat = new ServerSocketTCPBugCat();
	cat.run(args);
    }


    /**
     * Prepare method. Opens
     * ServerSocket to accept inbound connections. Called when main method
     * of this .jar is first invoked. redefined from superclass.
    */
    public void prepare () throws IOException {
	try {
	    serverSocket =new ServerSocket(port);
	    System.out.println("ServerSocket injector started in local " +
			       "host " +
			       serverSocket.getInetAddress().getLocalHost() +
			       " port " +serverSocket.getLocalPort());
	} catch (IOException e) {
	    System.out.println ("Error: " + e.getMessage());
	    System.exit(-1);
	    serverSocket = null;
	}
    }

    /**
     * finnish method. Close server socket on exit. redefined from super 
     * class. Called when all the requested testcases are injected.
    */
    public void finnish () throws IOException {
	try {
	    if (serverSocket != null) serverSocket.close();
	} catch (IOException e) {
	    System.out.println("Error: " + e.getMessage());
	    serverSocket = null;
	    System.exit(-1);
	}
    }

    /**
     * inject method. 
     */    
    public void inject (int index, byte[] metaData, byte[] data)
	throws IOException {

	/* add HTTP header to raw WMLC data */
	byte[] out_data = new byte [data.length + HTTP_HEADER.length()];
	System.arraycopy(HTTP_HEADER.getBytes(), 0, out_data, 0, 
			 HTTP_HEADER.length());
	System.arraycopy(data, 0, out_data, HTTP_HEADER.length(), 
			 data.length);

	System.out.print ("Waiting for connect...");
	
	/* Check that we have a valid serversocket before trying to inject 
	   anything */
	if (serverSocket != null) {
	    try {
		Socket socket = serverSocket.accept();
		InetAddress ia = socket.getInetAddress();	       
		InputStream  is = socket.getInputStream();
		OutputStream os = socket.getOutputStream();
		System.out.println ("connection from "+ ia.getHostName() +
				    " ["+ ia.getHostAddress() +"]");
		is.read();
		System.out.println ("Injecting testcase #" + index + 
				    ", data " + out_data.length + " bytes");
		os.write(out_data);
		os.flush();
		
		if (cdelay != 0) {
		    Thread.currentThread().sleep (cdelay);
		}
		
		socket.close();
		socket = null;
	    } catch (SocketException s) {
		System.out.println("Error: " + s.getMessage());
		System.exit(-1);
	    } catch (Exception e) {
		System.out.println("Error: " + e.getMessage());
		System.exit(-1);
	    }
	} else {
	    throw new IOException("null serverSocket");
	} /* end if serverSocket != null */
    }

    /**
      * Default constructor. Pretty empty.
    */
    public ServerSocketTCPBugCat() {
	
    }
    
}







