/*
*   Copyright (C) 2001 PROTOS Project Consortium, 2002 OUSPG
*     [http://www.ee.oulu.fi/research/ouspg/protos]
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2
*   as published by  the Free Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package FI.protos.ouspg.wrapper;

import java.io.*;
import java.util.jar.*;
import java.lang.reflect.*;
import java.text.*;
import java.awt.*;

public class InjectorUtilities {

    private static final String TESTCASE_PATH = "testcases/";
    private static final String[] PADDING = 	
    { "0000000" , "000000" , "00000" , "0000" , "000" , "00" , "0" , "" };
    private static final String CASEMASK = "00000000";

    private static String caseFormat (int idx) {
	try {
	    String s = Integer.toString (idx);
	    return TESTCASE_PATH + PADDING[s.length()] + s;
	} catch (ArrayIndexOutOfBoundsException ay) {
	    return null;
	}
    }
        
    public static boolean testCaseExists(int index) {
	return (getTestCase (index) == null ? false : true );
    }

    public static byte[] getTestCase(int index) {
	String s = caseFormat(index);
	return ( s==null ? null : getResource(s) );
    }

    public static byte[] getResource(String path) {	
	InputStream in = 
	    ClassLoader.getSystemClassLoader().getResourceAsStream(path);

	if(in == null) {
	    return null;
	}

	ByteArrayOutputStream out = new ByteArrayOutputStream();

	try {
	    int read = in.read();
	    while(read != -1) {
		out.write(read);
		read = in.read();
	    }
	    in.close();
	} catch(IOException e) {
	    e.printStackTrace();
	    System.exit(-1);
	}
	
	return out.toByteArray();
    }

    public static void parseCommandLine(String args[], Object methodSource)
	throws Throwable {
	try {
	    //parse command-line arguments
	    int index = 0;

 	    while (index < args.length) {
		String name = args[index];
		if (!name.startsWith("--")) {
		    throw new
			IllegalArgumentException("Invalid command line "
						 +"argument "+name);
		}
		name = name.substring(2); //name of the command-line argument
		index++;
		Method[] all_method = methodSource.getClass().getMethods();
		Method method = null;
		for(int a =0; a < all_method.length; a++) { 
		    //find the method to call
		    if (all_method[a].getName().equals(name)) {
			method = all_method[a];
			break;
		    }
		}
		if (method == null) {
		    throw new
			IllegalArgumentException("Unknown command line "+
						 "argument --"+name);
		}

		//get parameters of the argument
		Object parameter[] =
		    new Object[method.getParameterTypes().length];
		for(int a =0; a <parameter.length; a++) {
		    if (index == args.length) {
			throw new
			    IllegalArgumentException("Missing "+(a+1)
						     +". parameter for "
						     +"argument --"+name);
		    }
		    parameter[a] = args[index];
		    index++;
		}
		method.invoke(methodSource, parameter); //call the method
	    }
	} catch (IllegalArgumentException e) {
	    throw e;
	} catch (InvocationTargetException e) {
	    throw e.getCause();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
