#
# Display a FORM to select default config options to give the user
# control over the knobs and dials

#
# First figure out what radio buttons etc. should be "on". Note: the
# variables below are global. Perhaps we should hide in our own package
# name space.
#
my($rnd) = time();
@cf_attack_level = ();	$cf_attack_level[$attack_level] = "checked";
@cf_timeout = ();	$cf_timeout[$timeout] = "checked";
@cf_sub_zero = ();	$cf_sub_zero[$sub_zero_proximity] = "checked";
@cf_attack_proximate = ();
	$cf_attack_proximate[$attack_proximate_subnets] = "checked";
@cf_dont_nslookup = ();	$cf_dont_nslookup[$dont_use_nslookup] = "checked";
@cf_dont_ping = ();	$cf_dont_ping[$dont_use_ping] = "checked";
@cf_untrusted = ();	$cf_untrusted[$untrusted_host] = "checked";
@cf_extreme = ();	$cf_extreme[$extreme] = "checked";

print CLIENT <<EOF
<HTML>
<HEAD>
<TITLE>SAINT Configuration Management</TITLE>
<LINK REV="made" HREF="mailto:saint\@saintcorporation.com">
</HEAD>
<BODY BGCOLOR="white" vlink="#000000" link="#04289D">

<P></P>

<P>
<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0">
	<TR>
		<TD COLSPAN="2"><IMG SRC="$HTML_ROOT/images/config_mgmt_banner.gif" WIDTH="621" HEIGHT="106" ALIGN="BOTTOM" ALT="Configuration Management" BORDER="0"></TD>
	</TR>
	<TR>
	  <TD WIDTH="86" VALIGN="TOP">
	    <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0">
		<TR>
		    <TD WIDTH="86"><A HREF="http://www.saintcorporation.com"><IMG SRC="$HTML_ROOT/images/home.gif" WIDTH="86" HEIGHT="55" ALIGN="BOTTOM" ALT="SAINT Corporation"
			BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_ROOT/saint.html"><IMG SRC="$HTML_ROOT/images/home_button.gif" WIDTH="86" HEIGHT="46"
			ALIGN="BOTTOM" ALT="SAINT Home" BORDER="0" STYLE="Background-Image : none"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/data/saint_data_form.pl"><IMG SRC="$HTML_ROOT/images/data_mgmt_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Data Management" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/running/saint_run_form.pl"><IMG SRC="$HTML_ROOT/images/target_selection_button.gif"
			WIDTH="86" HEIGHT="46" ALIGN="BOTTOM" ALT="Target Selection" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_SERVER/reporting/analysis.pl"><IMG SRC="$HTML_ROOT/images/data_analysis_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Data Analysis" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><IMG SRC="$HTML_ROOT/images/config_mgmt_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Configuration Management" BORDER="0"></TD>
		</TR>
		<TR>
		    <TD WIDTH="86"><A HREF="$HTML_ROOT/saint_documentation.html"><IMG SRC="$HTML_ROOT/images/documentation_button.gif"
			WIDTH="86" HEIGHT="46" ALIGN="BOTTOM" ALT="SAINT Documentation" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86" HEIGHT="46"><A HREF="$HTML_ROOT/docs/FAQ.html#trouble"><IMG SRC="$HTML_ROOT/images/troubleshooting_button.gif" WIDTH="86"
			HEIGHT="46" ALIGN="BOTTOM" ALT="Troubleshooting" BORDER="0"></A></TD>
		</TR>
		<TR>
		    <TD WIDTH="86" HEIGHT="65"><IMG SRC="$HTML_ROOT/images/bottom_border.gif" WIDTH="86" HEIGHT="75" ALIGN="BOTTOM" ALT="--------" BORDER="0"></TD>
		</TR>
	    </TABLE>
	  </TD>
	  <TD VALIGN="TOP">
		<DL>
			<P>
		</DL>
<UL><UL>
<FORM METHOD=POST ACTION=saint_cf_action.pl>

<H2>Scanning levels and timeouts</H2>

<STRONG>What directory should I store the data in?</STRONG>
<DL compact>
<DT><DD><INPUT SIZE=25 NAME=saint_data VALUE=$saint_data>
SAINT data directory
</DL>
<P>

<STRONG>What probe level should I use?</STRONG>
<DL compact>
<DT><DD><INPUT TYPE="radio" NAME=attack_level VALUE=0 $cf_attack_level[0]>
Light
<DT><DD><INPUT TYPE="radio" NAME=attack_level VALUE=1 $cf_attack_level[1]>
Normal
<DT><DD><INPUT TYPE="radio" NAME=attack_level VALUE=2 $cf_attack_level[2]>
Heavy
<DT><DD><INPUT TYPE="radio" NAME=attack_level VALUE=3 $cf_attack_level[3]>
Heavy+
<DT><DD><INPUT TYPE="radio" NAME=attack_level VALUE=4 $cf_attack_level[4]>
Top 20 (scans specifically for
<A HREF="http://www.sans.org/top20.htm">SANS Top 20 Internet Security
Vulnerabilities</A>)
<DT><DD><INPUT TYPE="radio" NAME=attack_level VALUE=5 $cf_attack_level[5]>
Custom: <SELECT NAME=custom_level>
EOF
;
for (@custom_levels) {
	$selected = ($custom_level eq $_) ? " selected" : "";
	print CLIENT "<OPTION$selected>$_</OPTION>\n";
}
print CLIENT <<EOF
</SELECT>
(<A HREF="saint_custom_select.pl,cf,$rnd">Set up custom scan</A>)
</DL>

<P>
<STRONG>How many passwords should I guess against each account?</STRONG>
(Values greater than 2 will lock out accounts on some systems. 0 disables
password guessing.)
<DL compact>
<DT><DD><INPUT SIZE=2 NAME=password_guesses VALUE=$password_guesses> Password Guesses
</DL>

<P>
<STRONG>What timeout values should I use?</STRONG>
<DL compact>
<DT><DD><INPUT SIZE=3 NAME=long_timeout VALUE=$long_timeout> Slow
<DT><DD><INPUT SIZE=3 NAME=med_timeout VALUE=$med_timeout> Medium
<DT><DD><INPUT SIZE=3 NAME=short_timeout VALUE=$short_timeout> Fast
</DL>

<P>
<STRONG>Which of the above timeout values should I use for each SAINT check?</STRONG>
<DL compact>
<DT><DD><INPUT TYPE="radio" NAME=timeout VALUE=2 $cf_timeout[2]>
Slow
<DT><DD><INPUT TYPE="radio" NAME=timeout VALUE=1 $cf_timeout[1]>
Medium
<DT><DD><INPUT TYPE="radio" NAME=timeout VALUE=0 $cf_timeout[0]>
Fast
</DL>
<P>
<STRONG>What timeout values should I use for TCP and UDP port scans?</STRONG>
(This value should be increased on slower networks to ensure that services
are not missed.)
<DL compact>
<DT><DD><INPUT SIZE=3 NAME=tcpscan_timeout VALUE=$tcpscan_timeout> TCP Port Scan Timeout
<DT><DD><INPUT SIZE=3 NAME=udpscan_timeout VALUE=$udpscan_timeout> UDP Port Scan Timeout
</DL>
</P>

<P>
<STRONG>What is the maximum number of threads that can run concurrently?</STRONG>
(Higher values result in faster scans but require much more memory. To
disable multitasking, set this variable to 1.)
<DL compact>
<DT><DD><INPUT SIZE=3 NAME=maximum_threads VALUE=$maximum_threads>Maximum Threads
</DL>
<P>
<STRONG>What signal should I send to kill a tool process when it times out?</STRONG>
<DL compact>
<DT><DD><INPUT SIZE=3 NAME=timeout_kill VALUE=$timeout_kill>Kill signal
</DL>

<P>
<STRONG>How far out from the original target should I probe?</STRONG>
(Under no circumstances should this be higher than "2" unless you're
POSITIVE you know what you're doing!)
<DL compact>
<DT><DD><INPUT SIZE=3 NAME=max_proximity_level VALUE=$max_proximity_level>
Maximal proximity
</DL>

<P>
<STRONG>As I move out to less proximate hosts, how much should I drop
the probe level?</STRONG> (Only used with light, medium, heavy,
and heavy+ scan levels)
<DL compact>
<DT><DD><INPUT SIZE=3 NAME=proximity_descent VALUE=$proximity_descent>
Proximity descent
</DL>

<P>
<STRONG>When I go below 0 probe level, should I:</STRONG>
<DL compact>
<DT><DD><INPUT TYPE="radio" NAME=sub_zero_proximity VALUE=0 $cf_sub_zero[0]>Stop
<DT><DD><INPUT TYPE="radio" NAME=sub_zero_proximity VALUE=1 $cf_sub_zero[1]>Go on
</DL>

<P>
<STRONG>Should I do subnet expansion; that is, should I probe just the
target or its entire subnet?</STRONG> (Choosing just the target
will disable the smurf/fraggle check.)
<DL compact>
<DT><DD><INPUT TYPE="radio" NAME=attack_proximate_subnets VALUE=0
	$cf_attack_proximate[0]>Just the target
<DT><DD><INPUT TYPE="radio" NAME=attack_proximate_subnets VALUE=1
	$cf_attack_proximate[1]>The entire subnet
</DL>

<P>
<STRONG>Does $THIS_HOST appear in <i>rhosts, hosts.equiv</i> or
<i>NFS exports</i> files of hosts being probed?
</STRONG>

<DL compact>
<DT><DD><INPUT TYPE="radio" NAME=untrusted_host VALUE=0 $cf_untrusted[0]>
You are running SAINT from a possibly trusted host
<DT><DD><INPUT TYPE="radio" NAME=untrusted_host VALUE=1 $cf_untrusted[1]>
You are running SAINT from an untrusted host
</DL>

<P>
<STRONG>Targets' Netmask(s).</STRONG> For best
results, change this if your targets use unusual
subnetting. 255.255.255.0 is a Class C network.
Be very careful if you go below this (e.g. 255.255.254.0)
or you could scan outside your Class C.
<DL compact>
<DT><DD><INPUT TYPE=text SIZE=40 NAME=target_netmask VALUE="$target_netmask">
Netmask
</DL>

<P>
<HR>

<h2>Patterns specifying hosts to limit the probe to</h2>

If you only want to probe hosts within a specific domain, you could use,
for example:
<PRE>
	podunk.edu
</PRE>
<p>
If you only want to probe sites on a particular subnet, you could use,
for example:
<PRE>
	192.9.9
</PRE>
<p>
<INPUT SIZE=48 NAME=only_attack_these VALUE="$only_attack_these">
<p>
You can specify multiple shell-like patterns, separated by whitespace
or commas, and you may mix networks and domains. A host will be
scanned when it matches <i>any</i> pattern: either a network number prefix
or an internet domain suffix.

<hr>

<h2>Patterns specifying hosts to NOT probe</h2>

If you don't want to probe any military or governmental sites, you could use:
<PRE>
	mil, gov
</PRE>
<p>
<INPUT SIZE=48 NAME=dont_attack_these VALUE="$dont_attack_these">
<p>
You can specify multiple shell-like patterns, separated by whitespace
or commas, and you may mix networks and domains. A host will be
skipped when it matches <i>any</i> pattern: either a network number prefix
or an internet domain suffix.

<hr>

<H2>Whether to perform dangerous tests</H2>

Performing dangerous tests such as buffer overflows may
help reduce false alarms, but <b>may crash services on target
hosts!</b> (If a service crashes, further tests against that service
may result in false negatives.) See the <A HREF="$HTML_ROOT/docs/saint.cf.html#extreme-list">list of dangerous tests</A>.
<P>
<I>Note:</I> if you do not choose to perform dangerous tests,
SAINT will report a potential problem if there is a
possibility that the vulnerability exists.

<DL compact>
<DT><DD><INPUT TYPE="radio" NAME=extreme VALUE=0 $cf_extreme[0]>
Do not perform dangerous tests.
<DT><DD><INPUT TYPE="radio" NAME=extreme VALUE=1 $cf_extreme[1]>
Do perform dangerous tests. <b><i>Caution!</i></b>
</DL>

<hr>

<H2>Workarounds for broken DNS, ICMP etc.</H2>

<DL compact>
<DT><DD><INPUT TYPE="radio" NAME="dont_use_nslookup" VALUE="0" $cf_dont_nslookup[0]>
Use <i>nslookup</i> to look up fully-qualified (<i>host.domain</i>) host names
<DT><DD><INPUT TYPE="radio" NAME="dont_use_nslookup" VALUE="1" $cf_dont_nslookup[1]>
Don't use <i>nslookup</i>: DNS is unavailable.
</DL>

<DL compact>
<DT><DD><INPUT TYPE="radio" NAME="dont_use_ping" VALUE="0" $cf_dont_ping[0]>
Ping hosts to see if they are alive (skip non-responding hosts).
<DT><DD><INPUT TYPE="radio" NAME="dont_use_ping" VALUE="1" $cf_dont_ping[1]>
Don't ping hosts: ICMP does not work.
</DL>

<P>
<STRONG>Standard Ports</STRONG>
TCP ports to scan to determine whether a host is alive
when <I>don't ping hosts</I> is selected above or firewall
mode is enabled.
<DL compact>
<DT><DD><INPUT TYPE="text" NAME="std_ports" SIZE=30 VALUE="$std_ports">
</DL>
<P>
<HR>
<INPUT TYPE="submit" VALUE="Change the configuration file">
</FORM>
</UL></UL>
	  </TD>
	</TR>
</TABLE>
</BODY>
</HTML>
EOF
