#
# exclude_it.pl
# Adds listed entry to the exclusions list, then refreshes
use strict;

#Usage:
#exclude_it.pl,_url_,_record_
#where _url_ (usually the URL of calling report) will be brought up (refresh'ed)
#after setting the variable.
# and _record_ is Saint fact record for the severity to exclude
#Because the raw record may contain spaces, etc, we want _Record_ to be
#encoded with encode_url_arg

{

require "perl/exclusions.pl";

my ($rec,$url) = split(/,/, $::html_script_args,2);
my $record = &decode_url_arg($rec);

my $message = <<EOF;
<p>
Record $record will be added to exclusions list.
</p>
EOF

if ( ! $url )
{	$message= <<EOF2;
<h3>ERROR</h3>
<strong> reporting/exclude_it.pl called with wrong number of parameters.
</strong>
<p>
usage: <code>exclude_it.pl,<var>url</var>,<var>record</var></code>
EOF2

	$url=$::HTML_ROOT;
}

add_exclusion($record,$Exclusions::autosave);

&refresh_html(\*::CLIENT,$url,0,$message);
}

