#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
# Edits a given exclusion
#

use strict;

my $myurl="saint_exclusion_edit.pl";

generate_html_header(\*::CLIENT,"Exclusion Editor Results");

print ::CLIENT<<EOF;
<H1><Center>Edit an Exclusion</Center></H1>
<HR>
EOF

use strict;

require "perl/exclusions.pl";


#Prints detail of this record
my ($rec) = split(/,/, $::html_script_args,1);

my $origexc=decode_url_arg($rec);

my @newexc = (  $Exclusions::newtarget,
		$Exclusions::newservice,
		$Exclusions::newstatus,
		$Exclusions::newseverity,
		$Exclusions::newtrustee,
		$Exclusions::newtrusted,
		$Exclusions::newservice_output,
		$Exclusions::newtext,
		$Exclusions::newversion
		);
my $i;
for ($i=0; $i<scalar(@newexc); $i++)
{	$newexc[$i] =~ s/\+/ /g;
}

my $newexc = join '|', @newexc;

my $mode = $Exclusions::editmode;
#print "mode='$mode'\n";
#print "newtarget='$Exclusions::newtarget'\n";
#print "newstatus='$Exclusions::newstatus'\n";
#print "newservice_output='$Exclusions::newservice_output'\n";
my $message;

if ( $mode eq "change" )
{	drop_exclusion($origexc,0); #Hold off on autosave
	add_exclusion($newexc,$Exclusions::autosave);
	$message=<<EOF;
<p>Exclusion <code>$origexc</code> changed to <code>$newexc</code>.
EOF
} elsif ( $mode eq "new" )
{	
	add_exclusion($newexc,$Exclusions::autosave);
	$message=<<EOF;
<p>Exclusion added: <code>$newexc</code>.
EOF
} else
{	warn "Illegal mode $mode in $myurl";
	print ::CLIENT<<EOF;
<h2>Error in $myurl</h2>
Illegal mode $mode.  Please contact maintainer of code.
EOF
	&generate_html_footer(\*::CLIENT);
	return;
}

print ::CLIENT<<EOF;
<h2>Exclusion Successfully Editted</h2>
$message
<hr>
<ul>
<li><a href="saint_exclusion_list.pl">Back to exclusions list</a>
<li><a href="analysis.pl">Back to main analysis page</a>
</ul>
EOF

&generate_html_footer(\*::CLIENT);
