#
# unexclude_it.pl
# REmoves listed entry to the exclusions list, then refreshes
use strict;

#Usage:
#unexclude_it.pl,_url_,_record_
#where _url_ (usually the URL of calling report) will be brought up (refresh'ed)
#after setting the variable.
# and _record_ is Saint fact record for the severity to unexclude
# Because exclusions may be wild-carded, etc. there may be multiple exclusions
# for any given "fact".  Furthermore, an exclusion may affect other facts.
#This script will:
#i) determine if multiple exclusions apply to this fact
#ii) and if the exclusions apping to this fact affect any other hosts/severities
#
#If either i or ii apply, it produces a form informing the user of the possible
#consequences .
#Otherwise, it simply deletes goes to really_unexclude_it.pl



require "perl/exclusions.pl";


my ($rec,$url) = split(/,/, $::html_script_args,2);

my $fact = &decode_url_arg($rec);
my @fact = split_fact($fact);
my $host=$fact[$::TARGET_FIELD];
my $sev =$fact[$::SERVICE_OUTPUT_FIELD];


my @exclist = get_all_exclusions_matching_fact($fact);

my $message;

if ( scalar (@exclist) == 0 )
{	warn "Error in unexclude_it.pl: fact doesn't match any exclusions\n";
	$message="Error in unexclude_it.pl, fact didn;t match any exclusions";
	&refresh_html(\*::CLIENT,$url,0,$message);
	return;
}

my $wchost=undef;
my $wcsev=undef;
my $exc;
my @exc;
foreach $exc (@exclist)
{	@exc = split_exclusion($exc);
	if ( $exc[$::TARGET_FIELD] eq "*" ) { $wchost=1; }
	if ( $exc[$::SERVICE_OUTPUT_FIELD] eq "*" ) { $wcsev=1; }
	if ( $wchost && $wcsev ) { last; }
}

#Handle multiple record case
if ( scalar(@exclist) > 1 )
{	#Multiple exclusions exist
	&generate_html_header(\*::CLIENT,"Multiple Exclusion Delete");

	my $extra1=undef;
	my $extra2=undef;
	if ( $wchost || $wcsev  )
	{	$extra1="<h3>Affecting Multiple Hosts and/or Vulnerabilities</h3>";
		$extra2=<<EOF;
Some of these records are wild-carded on
the host and/or the vulnerability, and therefore removing all of these records
may cause previously excluded vulnerabilties to appear on other hosts or
services.  
<p>Wild-carding of hostname or vulnerabilities is not generally recommended,
and it is probably best for you to remove all the exclusions and re-apply
more specific exclusions if this causes any false positives.
EOF
	}

	print ::CLIENT<<EOF;
<h2>Requested Deletion of Multiple Exclusions </h2>
$extra1
<p>
The severity for which you wish to remove an exclusion is excluded by
multiple exclusion records. 
$extra2
<p>If you do not remove all the applicable exclusion records, the
$sev vulnerability on host $host will remain excluded.
<p>Select one of the following links to indicate your choice:
<ul>
<li><a href="really_unexclude_it.pl,F,$rec,$url,">
Remove all exclusion records relating to $sev on $host
</a>
<li><a href="saint_exclusion_list.pl">Edit the exclusion list manually
</a>
<li><a href="$url">Forget this and go back to the previous page</a>
<li><a href="analysis.pl">
Forget this and go back to the main data analysus page</a>
</ul>
EOF

	generate_html_footer(\*::CLIENT);
	return;
}


if ( $wchost || $wcsev )
{	#HAndle single record with wild cards
	&generate_html_header(\*::CLIENT,"Wildcard Exclusion Deletion Request");
	my $extra1=undef;
	my $extra2=undef;
	if ( $wchost && $wcsev )
	{	$extra1=<<EOF;
wild-cards for both the hostname and the vulnerability.  Removing this
exclusion may cause other previously excluded vulnerabilities and this
and/or other hosts to now appear.
EOF
	} elsif ( $wchost )
	{	$extra1=<<EOF;
a wild-card for  the hostname.  Removing this
exclusion may cause other previously excluded vulnerabilities of this type
on other hosts to now appear.
EOF
	} else
	{	$extra1=<<EOF;
a wild-card for the vulnerability.  Removing this
exclusion may cause other previously excluded vulnerabilities on this
hosts to now appear.
EOF
	}
	print ::CLIENT<<EOF;
<h2>Requested Deletion of Exclusions Wild-Carded on Host or Vulnerability</h2>
<p>
The severity for which you wish to remove an exclusion is excluded by
a record which has $extra1

<p>Wild-carding of hostname or vulnerabilities is not generally recommended,
and it is probably best for you to remove all the exclusions and re-apply
more specific exclusions if this causes any false positives.

<p>Select one of the following links to indicate your choice:
<ul>
<li><a href="really_unexclude_it.pl,F,$rec,$url,">
Remove the wild-carded exclusion 
</a>
<li><a href="saint_exclusion_list.pl">Edit the exclusion list manually
</a>
<li><a href="$url">Forget this and go back to the previous page</a>
<li><a href="analysis.pl">
Forget this and go back to the main data analysus page</a>
</ul>
EOF
	generate_html_footer(\*::CLIENT);
	return;
}

my $message = <<EOF;
<p>
Record $exclist[0] will be removed from exclusions list.
</p>
EOF

drop_exclusion($exclist[0],$Exclusions::autosave);

&refresh_html(\*::CLIENT,$url,0,$message);

