//bnf_parser.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD__BNF_PARSER_H__
#define __SEGER__MLTD__BNF_PARSER_H__

#include <string>
#include <map>
#include "bnf_ruleparser.h"

class bnf_parser
{
 public:
   bnf_parser(const char** defrule);
   //defrule -- rules them check bat convert to string
   bnf_parser(){}; //we must run load_defrule() before use
   ~bnf_parser();
   void load_defrule(const char**defrule);
   
   void reset_rule(string name,string rule);  //if error --> throw 
   void reset_rule(string name_rule);         //" name = rule "
   void add_rule(string name,string rule);    //add new rule (or change old)
   void add_rule(string name_rule);           //" name = rule "
   
   bool try_parse(bnf_parsval&, string root_rule,const string& toparse,
		  int& err_pos, string& err_rule);
   bool try_parse(bnf_parsval&,string root_rule,const char* toparse,int size,
		  int &err_pos,string&err_rule);
   bool try_parse(bnf_parsval&, string root_rule,const string& toparse);
   bool try_parse(bnf_parsval&, string root_rule,const char* toparse,int size);
   void reparse(string root_rule,string&rez,int r_len);
   bool is_rule_exist(string name){return rules.find(name) != rules.end();};
// private:
   map<string,bnf_rule*> rules;
 private:
   void clear();  //delete all
};

#endif
