//bnf_rule.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "bnf_rule.h"
#include <iostream>
using namespace std;

void bnf_rule::reset_items(vector<bnf_ruleitem*>&r)
{
   clear_items();
   items=r;
}
//                                                                            
bool bnf_rule::try_parse(bnf_parsval& pv, str_cit& curr, const string& toparse,
			 str_cit& err_it, string& err_rule)
{
//   cout<<"Enter rule="<<name<<" end-curr="<<end-curr<<endl;
   err_it=toparse.end();            //not error
   str_cit init_it=curr;            //keep init position
   pv.name()=name;
   pv.position()=curr-toparse.begin();
   bnf_parsval tmp_pv;
   for (unsigned int i=0;i<items.size();i++)
     if (!items[i]->try_parse(tmp_pv, curr, toparse, err_it, err_rule))
       {
	  if (err_it==toparse.end()) //error in this field
	    {
	       err_it=curr;
	       err_rule=name;
	    }
	  curr=init_it;   //return to init position (may be we try again)
	  return false;
       }
   pv.move_pvs_from(tmp_pv);
   pv.add_data( string(init_it, curr) );
  // cout<<"True in rule="<<name<<" end-curr="<<end-curr<<endl;
   return true;
}
//                                                                            
void bnf_rule::reparse(string& rez,int r_len)
{
   for (unsigned int i=0;i<items.size();i++)
     items[i]->reparse(rez,r_len);
}
//                                                                            
void bnf_rule::clear_items()
{
   for (unsigned int i=0;i<items.size();i++)
     delete items[i];
   items.resize(0);
}

//                                                                            
//                                                                            

bnf_ruleitem_rule::bnf_ruleitem_rule(int min_,int max_,bnf_rule* rit)
  :bnf_ruleitem(min_,max_)
{
   self_rule=rit;
//   cout<<"Enter in bnf_ruleitem_rule name="<<rit->get_name()<<endl;
//   cout<<"                 min_="<<min_<<" max_="<<max_<<endl;
}
//                                                                            
bool bnf_ruleitem_rule::pure_try_parse(bnf_parsval& pv, str_cit& curr,
				       const string&toparse,
				       str_cit & err_it,
				       string & err_rule)
{
//   cout<<"Enter in rule bnf_ruleitem_rule="<<self_rule->get_name()<<endl;
   bnf_parsval* pv1=new bnf_parsval;
   if (self_rule->try_parse(*pv1, curr, toparse, err_it, err_rule))
     {
	pv.add_parsval(pv1);
	return true;
     }
   delete pv1;
   return false;
}
//                                                                            
void bnf_ruleitem_rule::pure_reparse(string&rez,int r_len)
{
   self_rule->reparse(rez,r_len);
}
//                                                                            
