//bnf_rule.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)
#include "bnf_ruleitem.h"
#include <iostream>
#include <stdexcept>
using namespace std;

bool bnf_ruleitem::try_parse(bnf_parsval& pv, str_cit& curr,
			     const string& toparse,
			     str_cit& err_it, string& err_rule)
{
   //   cout<<"Enter in bnf_ruleitem::try_parse"<<endl;
   //   cout<<"  min="<<min<<" max="<<max<<endl;
   int i=0;
   for (;i<min;i++)
     if (!pure_try_parse(pv, curr, toparse, err_it, err_rule))
       return false;
   //at least min
   for (; i<max || max==MAX_MAX; i++)
     if (!pure_try_parse(pv, curr, toparse, err_it, err_rule))
       {
	  err_it = toparse.end();   //not error
	  return true;
       }
   return true ; 
}
//                                                                            
void bnf_ruleitem::reparse(string&rez,int r_len)
{
   for (int i=0;i<min;i++)
     pure_reparse(rez,r_len);
   int tmp_max=0;
   if (max==MAX_MAX)
     tmp_max=random() % (r_len+1);
   else
     tmp_max=random() % (max - min + 1);
   for (int i=0;i<tmp_max;i++)
     pure_reparse(rez,r_len);
}
//                                                                            
//                                                                            

bnf_ruleitem_string::bnf_ruleitem_string(int min_,int max_,string str_)
  :bnf_ruleitem(min_,max_)
{
   str=str_;
   //   cout<<"Enter in bnf_ruleitem_string str="<<str<<endl;
   //   cout<<"                 min_="<<min_<<" max_="<<max_<<endl;
}
//                                                                            
bool bnf_ruleitem_string::pure_try_parse(bnf_parsval& pv, str_cit& curr,
					 const string& toparse,
					 str_cit& err_it,
					 string &err_rule)
{
   if (curr == toparse.end())
     return false;
   string::size_type pos=0;
   str_cit curr_init=curr;  //keep init it
   while ( ( curr != toparse.end() ) && ( pos < str.size() ) )
     {	
	if (!cmp_char( *curr , str[pos] ))
	  pos=str.size() + 1; //go to and of string 
	pos++;
	curr++;
     }
   if ( pos != str.size())
     {
	curr=curr_init;
	return false;
     }
   return true;
}
//                                                                            
void bnf_ruleitem_string::pure_reparse(string&rez,int r_len)
{
   for (unsigned int i=0;i<str.size();i++)
     {
	if (random() % 2)
	  rez+=toupper(str[i]);
	else
	  rez+=tolower(str[i]);
     }
}
//                                                                            
//                                                                            


bnf_ruleitem_group::bnf_ruleitem_group(int min_,int max_,
				       vector<bnf_ruleitem*> items_)
  :bnf_ruleitem(min_,max_)
{
   //   cout<<"Enter in bnf_ruleitem_group size="<<items_.size()<<endl;
   // cout<<"                 min_="<<min_<<" max_="<<max_<<endl;
  items=items_;   
}
//                                                                            
bnf_ruleitem_group::~bnf_ruleitem_group()
{
   for (unsigned int i=0;i<items.size();i++)
     delete items[i];
}
//                                                                            
bool bnf_ruleitem_group::pure_try_parse(bnf_parsval& pv,str_cit& curr,
					const string& toparse,
					str_cit& err_it,
					string &err_rule)
{
   //   cout<<"Enter in bnf_ruleitem_group::pure_try_parse it.size="<<
   //     items.size()<<endl;
   str_cit curr_init=curr;
   bnf_parsval tmp_pv;
   for (unsigned int i=0;i<items.size();i++)
     if (!items[i]->try_parse(tmp_pv, curr, toparse, err_it, err_rule))
       {
	  curr=curr_init;
	  return false;
       }
   pv.move_pvs_from(tmp_pv);
   return true;
}
//                                                                            
void bnf_ruleitem_group::pure_reparse(string&rez,int r_len)
{
   for (unsigned int i=0;i<items.size();i++)
     items[i]->reparse(rez,r_len);
}
//                                                                            
//                                                                            

bnf_ruleitem_orgroup::bnf_ruleitem_orgroup(int min_,int max_,
					   vector<bnf_ruleitem*> items_)
  :bnf_ruleitem_group(min_,max_,items_)
{
   //   cout<<"Enter in bnf_ruleitem_orgroup size="<<items_.size()<<endl;
   // cout<<"                 min_="<<min_<<" max_="<<max_<<endl;
}
//                                                                            
bool bnf_ruleitem_orgroup::pure_try_parse(bnf_parsval& pv,str_cit& curr,
					  const string& toparse,
					  str_cit& err_it,
					  string &err_rule)
{
   //Rule: maximal. If equal then first
   //   cout<<"Enter in bnf_ruleitem_orgroup::pure_try_parse it.size="<<
   //     items.size()<<endl;
   str_cit curr_init=curr;
   vector<bnf_parsval*> tmp_pvs;   //last parsval --> empty
   tmp_pvs.push_back(new bnf_parsval);
   vector<string::size_type> sizes;              //sizes.size=tmp_pvs.size - 1
   for (unsigned int i=0;i<items.size();i++)
     {
	if (items[i]->try_parse(*tmp_pvs.back(), curr, toparse, err_it, err_rule))
	  {
	     sizes.push_back(curr - curr_init);     //calculate size
	     tmp_pvs.push_back(new bnf_parsval);    //create new empty parsval
	     curr=curr_init;
	  }
	else
	  if (curr!=curr_init)  //if false then must safe position
	    throw logic_error(string("Interanal error in")+
			      "bnf_ruleitem_orgroup::pure_try_parse");
     }
   if (tmp_pvs.size()>1)   //find some match
     {
	 //find max_size
	string::size_type max_size=sizes[0];
	for (unsigned int i=1;i<sizes.size();i++)
	  if ( max_size < sizes[i] )
	    max_size=sizes[i];
	//find first with max_size
	for (unsigned int i=0;i<sizes.size();i++)
	  if ( sizes[i] == max_size )
	    {
	       pv.move_pvs_from(*tmp_pvs.at(i));
	       curr=curr_init + sizes[i];
	       i=sizes.size();   //stop loop
	    }
     }
   for (unsigned int i=0;i<tmp_pvs.size();i++)
     delete tmp_pvs[i];
   if (tmp_pvs.size()==1)  //not find any match
     return false;
   return true;
}
//                                                                            
void bnf_ruleitem_orgroup::pure_reparse(string&rez,int r_len)
{
   int i=random() % items.size();
   items[i]->reparse(rez,r_len);
}
//                                                                            
//                                                                            

bnf_ruleitem_pointhval::bnf_ruleitem_pointhval(int min_, int max_, 
					       vector<int>& vval)
  :bnf_ruleitem_string(min_,max_,string())
{
   string tmp;
   for (unsigned int i=0;i<vval.size();i++)
     tmp.push_back((char)vval[i]);
   set_str(tmp);
   //   cout<<"Enter in bnf_ruleitem_pointhval str="<<tmp<<endl;
   // cout<<"                 min_="<<min_<<" max_="<<max_<<endl;
}
//                                                                            
void bnf_ruleitem_pointhval::pure_reparse(string&rez,int r_len)
{
   rez+=str;
}
//                                                                            
//                                                                            

bnf_ruleitem_rangehval::bnf_ruleitem_rangehval(int min_,int max_,
					       unsigned char hmin_,
					       unsigned char hmax_)
  :bnf_ruleitem(min_,max_)
{
   hmin=hmin_;
   hmax=hmax_;
//   cout<<"Enter in bnf_ruleitem_rangehval hmin="<<hmin<<" hmax="<<hmax<<endl;
//   cout<<"                 min_="<<min_<<" max_="<<max_<<endl;
}
//                                                                            

bool bnf_ruleitem_rangehval::pure_try_parse(bnf_parsval& pv, str_cit& curr,
					    const string& toparse,
					    str_cit & err_it,
					    string &err_rule)
{
   if (curr == toparse.end())
     return false;
   if ( (unsigned char)*curr >=hmin && (unsigned char)*curr <= hmax)
     {
	curr++;
	return true;
     }
   return false;
}
//                                                                            
void bnf_ruleitem_rangehval::pure_reparse(string&rez,int r_len)
{
   rez+=hmin + (unsigned char) (random() % (hmax - hmin + 1 ));
}
//                                                                            
//                                                                            
