//bnf_ruleitem.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD__BNF_RULEITEM_H__
#define __SEGER__MLTD__BNF_RULEITEM_H__

#include <string>
#include <vector>
#include <cctype>
#include "bnf_parsval.h"
#include "bnf_strtype.h"
using namespace std;

class bnf_ruleitem
{
 public:
   bnf_ruleitem(int min_, int max_) {min=min_; max=max_;};
   virtual ~bnf_ruleitem(){};
   
   bool try_parse(bnf_parsval &,str_cit &curr , const string& toparse,
		  str_cit& err_it,string& err_rule);
   void reparse(string&rez,int r_len);
 protected:
   virtual bool pure_try_parse(bnf_parsval& ,str_cit&curr,
			       const string& toparse,
			       str_cit & err_it, string& err_rule)=0;
   virtual void pure_reparse(string&rez,int r_len)=0;
 private:
   int min,max;  //*.*
 public:
   static const int MAX_MAX=100000;
};
//                                                                            
class bnf_ruleitem_string: public bnf_ruleitem
{
 public:
   bnf_ruleitem_string(int min, int max, string str);
 protected:
   virtual bool pure_try_parse(bnf_parsval& ,str_cit&curr ,
			       const string&toparse,
			       str_cit & err_it, string& err_rule);
   virtual bool cmp_char(char c1,char c2){return toupper(c1)==toupper(c2);};
     //string may be in any case
   void set_str(string str_){str=str_;};
   virtual void pure_reparse(string&rez,int r_len);
 protected:
   string str;
};
//                                                                           
class bnf_ruleitem_group: public bnf_ruleitem
{
 public:
   bnf_ruleitem_group(int min, int max, vector<bnf_ruleitem*> items);
   ~bnf_ruleitem_group();
 protected:
   virtual bool pure_try_parse(bnf_parsval& ,str_cit&curr ,
			       const string& toparse,
			       str_cit & err_it, string& err_rule);
   virtual void pure_reparse(string&rez,int r_len);
 protected:
   vector<bnf_ruleitem*> items;
};
//                                                                           
class bnf_ruleitem_orgroup: public bnf_ruleitem_group
{
 public:
   bnf_ruleitem_orgroup(int min,int max,vector<bnf_ruleitem*> items);
 protected:
   virtual bool pure_try_parse(bnf_parsval& ,str_cit&curr ,
			       const string& toparse,
			       str_cit & err_it, string& err_rule);
   virtual void pure_reparse(string&rez,int r_len);
};
//                                                                           
class bnf_ruleitem_pointhval:public bnf_ruleitem_string
{
 public:
   bnf_ruleitem_pointhval(int min,int max,vector<int>& vval);   
 protected:
   virtual bool cmp_char(char c1,char c2){return c1==c2;};
   virtual void pure_reparse(string&rez,int r_len);
};
//                                                                           
class bnf_ruleitem_rangehval:public bnf_ruleitem
{
 public:
   bnf_ruleitem_rangehval(int min,int max,unsigned char hmin,
			  unsigned char hmax);
 protected:
   virtual bool pure_try_parse(bnf_parsval& ,str_cit&curr ,
			       const string& toparse,
			       str_cit & err_it, string& err_rule);
   virtual void pure_reparse(string&rez,int r_len);
 private:
   unsigned char hmin,hmax;
};

#endif
