//sipbct_pdu.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbct_pdu.h"
#include "sipb_addfun.h"
#include <fstream>
#include <stdexcept>

bool sipbct_pdu::read(string file)
//we use format that discribet in 
//http://www.ee.oulu.fi/research/ouspg/protos/testing/c07/sip/
{
   ifstream in(file.c_str());
   if (!in)
     return false;
   int tmp;
   if (!read_int_prob(in,tmp))   //read INVITE PDUs size
     return false;
   if (!read_str(in,invite,tmp)) //read INVITE PDU
     return false;
   if (!read_int_prob(in,tmp))   //read teardown template size
     return false;
   if (!read_str(in,teardown,tmp)) //read teardown template
     return false;
   return true;   
}
//                                                                            
string sipbct_pdu::get_invite(map<string,string>& to_change)
{
   string tmp=invite;
   make_change(tmp,to_change);
   make_cl_change(tmp); //calculate content length
   return tmp;
}
//                                                                            
string sipbct_pdu::get_teardown(map<string,string>&to_change,string method)
{
   string tmp=teardown;
   make_change(tmp,to_change);
   map<string,string> mc;     //not too fast but me not need to speed
   mc["Teardown-Method"]=method;
   make_change(tmp,mc);
   make_cl_change(tmp);
   return tmp;
}
//                                                                            
bool sipbct_pdu::read_int_prob(istream&in,int &i)
{
   char c;
   string str;
   while (in.get(c))
     {
	if (c!=' ')
	  str+=c;
	else
	  {
	     i=atoi(str.c_str());
	     if (i<=0)
	       return false;
	     return true;
	  }
     }
   return false;
}
//                                                                            
bool sipbct_pdu::read_str(istream&in,string &str,int size)
{
   str.resize(0);
   char c;
   for (int i=0;i<size;i++)
     {
	if (!in.get(c))
	  return false;
	str.push_back(c);
     }
   return true;
}
//                                                                            
bool sipbct_pdu::find_next(string&in, int pos_begin,int& pos_rez,int&size,string& name)
{
   unsigned int p=pos_begin;
   while (p < in.size())
     {
	if (in[p] == '<')
	  {
	     unsigned int tmp = p + 1;
	     while (tmp<in.size() && ( isalpha(in[tmp]) || isdigit(in[tmp]) ||
				       in[tmp]=='-'))
	       tmp++;
	     if (tmp<in.size() && in[tmp]=='>')
	       {
		  pos_rez = p;
		  size = tmp - pos_rez + 1;
		  name.assign(in,pos_rez + 1,size - 2);
		  return true;
	       }
	  }
	p++;
     }
   return false;
}
//                                                                            
void sipbct_pdu::make_change(string& str,map<string,string>&to_change)
{
   int pos=0;
   int pos_rez,size;
   string name;
   while (find_next(str,pos,pos_rez,size,name))
     {
	map<string,string>::const_iterator it=to_change.find(name);
	if (it!=to_change.end())
	  {
	     str.replace(pos_rez,size,it->second);
	     pos = pos_rez + it->second.size();
	  }
	else
	  pos = pos_rez + 1;
     }
}
//                                                                            
void sipbct_pdu::make_cl_change(string &str)
{
   //first calculate content length
   int cl=str.size()-str.find("\x0D\x0A\x0D\x0A")-4;
   if (cl<0)
     throw logic_error("Error in sipbct_pdu::make_cl_change");
   //convert to string
   map<string,string> to_change;
   to_change["Content-Length"]=int_to_str(cl);
   make_change(str,to_change);
}
