//sipbst_cert.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst_cert.h"
#include "sipb_bnftools.h"
#include "sipb_addfun.h"
#include <sys/types.h>
#include <dirent.h>
#include <sys/poll.h>
#include <stdexcept>

#include <iostream>
using namespace std;

sipbst_cert::sipbst_cert()
{
   paramlist()->add_wanted(SIPB_SP_SIPSERVER,true,
			   SIPB_SP_SIPSERVER_DEF);
   paramlist()->add_wanted_int(SIPB_SP_SERV_UDPPORT,true,0,
			       SIPB_SP_MAX_PORT,
			       SIPB_SP_SERV_UDPPORT_DEF);
   paramlist()->add_wanted_int(SIPB_SP_NSEND,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_NSEND_CERT_DEF);
   paramlist()->add_wanted(SIPB_SP_CERT_FROM,true,
			   SIPB_SP_CERT_FROM_DEF);
   paramlist()->add_wanted(SIPB_SP_CERT_FROMADDRESS,true,
			   SIPB_SP_CERT_FROMADDRESS_DEF);
   paramlist()->add_wanted(SIPB_SP_CERT_FROMIP,true,
			   SIPB_SP_CERT_FROMIP_DEF);
   paramlist()->add_wanted(SIPB_SP_CERT_TO,true,
			   SIPB_SP_CERT_TO_DEF);
   paramlist()->add_wanted(SIPB_SP_CERT_TEARDOWNLIST,true,
			   SIPB_SP_CERT_TEARDOWNLIST_DEF);
   paramlist()->add_wanted(SIPB_SP_CERT_TESTDIR,true,
			   SIPB_SP_CERT_TESTDIR_DEF);
   paramlist()->add_wanted_int(SIPB_SP_CERT_TDTIMEOUT,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_CERT_TDTIMEOUT_DEF);
   paramlist()->add_wanted_int(SIPB_SP_CERT_MID_TDTIMEOUT,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_CERT_MID_TDTIMEOUT_DEF);
   paramlist()->add_wanted_int(SIPB_SP_CERT_TESTTIMEOUT,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_CERT_TESTTIMEOUT_DEF);
}
//                                                                            
void sipbst_cert::work()
{
   if (!get_param())
     return;
   for (int i=0;i<n_send;i++)
     {
	if (check_wantstop())
	  return;
	vector<string> tests;
	if (!make_test_list(tests))
	  {
	     add_gen_error("Can't find CERT-testdir ....");
	     return;
	  }
	for (unsigned int j=0;j<tests.size() && !check_wantstop();j++)
	  {
	     try
	       {
		  make_cert_test(tests[j]);
	       }
	     catch(exception&ex)
	       {
		  cout<<"Error then try run test="<<tests[j]<<endl;
		  cout<<ex.what()<<endl;
	       }
	  }
     }
}
//                                                                            
bool sipbst_cert::get_param()
{
   if (!serv_ip.try_set(paramlist()->get(SIPB_SP_SIPSERVER)))
     {
	add_gen_error("Bad server name");
	return false;
     }
   udp_port=paramlist()->get_int(SIPB_SP_SERV_UDPPORT);
   n_send=paramlist()->get_int(SIPB_SP_NSEND);
   from=paramlist()->get(SIPB_SP_CERT_FROM);
   from_address=paramlist()->get(SIPB_SP_CERT_FROMADDRESS);
   from_ip=paramlist()->get(SIPB_SP_CERT_TO);
   to=paramlist()->get(SIPB_SP_CERT_TO);
   testdir=paramlist()->get(SIPB_SP_CERT_TESTDIR);
   
   string::size_type last_slash=testdir.find_last_of('/');
   if (last_slash==string::npos)
     {
	testdir="./"+testdir;
	last_slash=testdir.find_last_of('/');
     }
   teardown_list.resize(0);
   sipb_bnftools::vec_add(paramlist()->get(SIPB_SP_CERT_TEARDOWNLIST),
			  teardown_list);
   td_timeout=paramlist()->get_int(SIPB_SP_CERT_TDTIMEOUT);
   test_timeout=paramlist()->get_int(SIPB_SP_CERT_TESTTIMEOUT);
   td_mid_timeout=paramlist()->get_int(SIPB_SP_CERT_MID_TDTIMEOUT);
   return true;
}
//                                                                            
void sipbst_cert::make_cert_test(string test)
{
   //refresh network
   udp_send.rebind();
   udp_recv.rebind();
   //create change map
   map<string,string> to_change;
   to_change["CSeq"]=int_to_str(random()%1000000);
   to_change["Call-ID"]=sipb_bnftools::nalpha(10);
   to_change["From"]=from;
   to_change["From-Address"]=from_address;
   to_change["From-IP"]=from_ip;
   to_change["Local-Port"]=int_to_str(udp_recv.get_port());
   to_change["To"]=to;
   //read PDU
   if (!pdu.read(test))
     add_gen_error("Can't read test="+test);
   
   //send first packet
   send_recv(pdu.get_invite(to_change),td_timeout,"We run "+test);
   //send all teardown
   for (unsigned int i=0;i<teardown_list.size();i++)
     send_recv(pdu.get_teardown(to_change,teardown_list[i]),td_mid_timeout);
   poll(0,0,test_timeout);
}
//                                                                            
bool sipbst_cert::make_test_list(vector<string>&test_list)
{
   test_list.resize(0);
   string::size_type last_slash=testdir.find_last_of('/');
   if (last_slash==string::npos)
     throw logic_error("Error in sipbst_cert::make_test_list");
   string dir_name(testdir,0,last_slash + 1);
   string file_name;
   if (last_slash < testdir.size()-1)
     file_name.assign(testdir, last_slash + 1 , 
		      testdir.size() - last_slash - 1); 
 
   //open dir and compare
   DIR *dir;
   dirent* d;
   string name;
   dir=opendir(dir_name.c_str());
   if (!dir)
     {
	closedir(dir);
	return false;
     }
   while ( (d = readdir(dir)) != NULL )
     if ( (string(d->d_name) != ".") && (string(d->d_name) != ".."))
       if (cmp_withstar(file_name,d->d_name))
	 test_list.push_back(dir_name + "/" + d->d_name);
   closedir(dir);
   return true;
}
//                                                                            
bool sipbst_cert::cmp_withstar(string mask,string file_name)
{
   string::size_type star_pos=mask.find('*');
   if (star_pos==string::npos)
     return mask==file_name;
   string mask_before(mask,0,star_pos);
   string mask_after(mask,star_pos+1,mask.size()-star_pos-1);

   if (mask_before.size()>0 && file_name.find(mask_before)!=0)
     return false;
   if (mask_after.size()>0 &&
       file_name.rfind(mask_after) !=
       (file_name.size() - mask_after.size()))
     return false;
   return true;
}
//                                                                            
void sipbst_cert::send_recv(string message,int ms_timeout,string str)
{
   sipb_stpacket * tosend=new sipb_stpacket;
   sipb_stpacket * torecv=new sipb_stpacket;
   if (str.size()>0) 
     tosend->add_info(str);
   tosend->pack=message;
   if (!udp_send.send(serv_ip.ip(), udp_port , *tosend))
     {
	if (udp_send.check_hungup())
	  {
	     add_gen_error("Probably server down");
	     set_wantstop();
	  }
	else
	  tosend->add_error("Can't send this packet (probably too big for UDP)");
	push_packet(tosend);
	delete torecv;
	return;
     }
   push_packet(tosend);
   if (!udp_recv.recv(serv_ip.ip(),udp_port,*torecv,ms_timeout))
     {
	if (udp_send.check_hungup() || udp_recv.check_hungup())
	  {
	     add_gen_error("Probably server down");
	     set_wantstop();
	  }
	delete torecv;
	return;
     }
   push_packet(torecv);
   return;
}
