//sipbst_cert.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//Interface to CERT-test
//look http://www.ee.oulu.fi/research/ouspg/protos/testing/c07/sip/ for detail
#ifndef __MLTD__SIPBST_CERT_H__
#define __MLTD__SIPBST_CERT_H__

#include "sipb_stest.h"
#include "sipb_ipaddr.h"
#include "sipbct_pdu.h"
#include "sipb_transport.h"

class sipbst_cert:public sipb_stest
{
 public:
   sipbst_cert();  //for add parameter
   string name(){return "CERT_TEST";};
 protected:
   void work();
 private:
   sipb_udptrans udp_send,udp_recv;
   int udp_port;
   int n_send; //Number of send test
   int td_timeout,td_mid_timeout,test_timeout;
   string from,from_address,from_ip,to;
   vector<string> teardown_list;
   string testdir;
   sipb_ipaddr serv_ip;
   sipbct_pdu pdu;
 private:
   bool get_param();
   void make_cert_test(string test);
   bool make_test_list(vector<string>&str);
   bool cmp_withstar(string mask,string file_name);
   void send_recv(string message,int ms_timeout,string message_to_send="");
};

#endif

