//qsipb_ewshower.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)
  
#include "qsipb_ewshower.h"
#include "sipb_addfun.h"

void qsipb_ewshower::ewprint(sipb_errwarn& ew,int packet_id)
{
   if (packet_id < 0)  //general errwarn
     {
	for (int i=0;i<ew.err_size();i++)
	  add_err("General Error:   " + ew.err(i));
	for (int i=0;i<ew.warn_size();i++)
	  add_warn("General Warning: " + ew.warn(i));
	for (int i=0;i<ew.info_size();i++)
	  add_info("General Info:    " + ew.info(i));
	return;
     }
   for (int i=0;i<ew.err_size();i++)
     add_err("Packet Error n="+int_to_str(packet_id)+": "+ew.err(i));
   for (int i=0;i<ew.warn_size();i++)
     add_warn("Packet Warning n=" + int_to_str(packet_id)+": " + ew.warn(i));
   for (int i=0;i<ew.info_size();i++)
     add_info("Packet Info n=" + int_to_str(packet_id) + ": " + ew.info(i));
   return;
}
//                                                                            
