//qsipb_handtest.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_handtest.h"
#include "sipb_ipaddr.h"
#include "sipb_addfun.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_bnftools.h"
#include "sipb_def.h"

#include <qhbox.h>
#include <qvbox.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include <qhbuttongroup.h>
#include <qvalidator.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <stdexcept>

using namespace std;


qsipb_handtest::qsipb_handtest(QWidget*p)
  :QWidget(p),p(sipb_bnfrules_forparse)
{
   QVBoxLayout*  main_layout=new QVBoxLayout(this,10);
   QHBoxLayout*  up_layout  =new QHBoxLayout(main_layout,10);
   QHBoxLayout*  down_layout=new QHBoxLayout(main_layout,10);
   
   pe_send=new qsipb_packetedit(this);
   up_layout->addWidget(pe_send);

   QVGroupBox* param_box=new QVGroupBox(this);
   up_layout->addWidget(param_box);

   pl=new qsipb_ht_plist(this);
   up_layout->addWidget(pl);
   up_layout->setStretchFactor(pe_send,3);
   up_layout->setStretchFactor(pl,2);

   ib=new qsipb_infobar(this);
   down_layout->addWidget(ib);
   
   pv=new qsipb_packetview(this);
   down_layout->addWidget(pv);

   
   //cerate parameters
   
   
   QHBox* hb       =new QHBox(param_box);
   QLabel* l       =new QLabel("Server",hb);
   le_serv         =new QLineEdit("127.0.0.1",hb);
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(le_serv,1);
   
   hb     =new QHBox(param_box);
   l      =new QLabel("Port  ",hb);
   le_port=new QLineEdit("5060",hb);
   le_port->setValidator(new QIntValidator(0,65536,le_port));
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(le_port,1);
   
   hb                 =new QHBox(param_box);
   l                  =new QLabel("Transport",hb);
   cob_transport      =new QComboBox(false,hb);  //create readonly combobox
   cob_transport->insertItem(SIPB_TRANS_UDP);
   cob_transport->insertItem(SIPB_TRANS_TCP);
   cob_transport->insertItem(SIPB_TRANS_TCP_BROKEN);
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(cob_transport,1);
   
   hb        =new QHBox(param_box);
   l         =new QLabel("Timeout",hb);
   le_timeout=new QLineEdit("500",hb);
   le_timeout->setValidator(new QIntValidator(0,100000000,le_timeout));
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(le_timeout,1);
   

   hb         =new QHBox(param_box);
   l          =new QLabel("Auto Change Via",hb);
   cb_autovia =new QCheckBox(hb);
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(cb_autovia,1);
   cb_autovia->toggle();

   hb         =new QHBox(param_box);
   l          =new QLabel("Auto Auth",hb);
   cb_autoauth=new QCheckBox(hb); 
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(cb_autoauth,1);
   cb_autoauth->setEnabled(false);
   
   
   hb       =new QHBox(param_box);
   l        =new QLabel("CRLF",hb);
   cob_crlf =new QComboBox(false,hb);
   cob_crlf->insertItem(SIPB_HT_CRLF_CRLF);
   cob_crlf->insertItem(SIPB_HT_CRLF_CR);
   cob_crlf->insertItem(SIPB_HT_CRLF_LF);
   hb->setStretchFactor(l,1);
   hb->setStretchFactor(cob_crlf,1);
   
   
   
   
   hb         =new QHBox(param_box);
   QPushButton* pb_send=new QPushButton("Send",hb);
   hb->setStretchFactor(new QWidget(hb),1);
   QPushButton* pb_write=new QPushButton("Save",hb);

   
   hb         =new QHBox(param_box);
   QPushButton* pb_clear=new QPushButton("Clean",hb);
   hb->setStretchFactor(new QWidget(hb),1);
   QPushButton* pb_load=new QPushButton("Load",hb);
   
   //make transoprts by default
   tr_send=new sipb_udptrans;
   tr_recv=new sipb_udptrans;
   is_sr_same=false;
   want_change_tr(cob_transport->currentItem());  //print

   //make connects
   
   connect(pb_send,SIGNAL(clicked()),this,SLOT(want_send_packet()));
   connect(pb_write,SIGNAL(clicked()),this,SLOT(want_write()));
   connect(pb_clear,SIGNAL(clicked()),this,SLOT(want_clean()));
   connect(pb_load,SIGNAL(clicked()),this,SLOT(want_load()));
   
   connect(pl,SIGNAL(is_want_show_packet(sipb_stpacket*)),pv,
	   SLOT(set_packet(sipb_stpacket*)));
   
   connect(cob_transport,SIGNAL(activated(int)),this,SLOT(want_change_tr(int)));
   connect(pv,SIGNAL(is_tohandtest(sipb_stpacket&)),this,
	   SLOT(want_set_packet(sipb_stpacket&)));
}
//                                                                            
qsipb_handtest::~qsipb_handtest()
{
   delete tr_send;
   delete tr_recv;
}
//                                                                            
void qsipb_handtest::want_set_packet(sipb_stpacket& rd)
{
   pe_send->set_packet(rd.pack);
}
//                                                                            
void qsipb_handtest::want_write()
{
   if (!pl->firstChild())  //empty
     return;
   QString fn=QFileDialog::getSaveFileName("","",this);
   if (fn.length()==0)
     return;
   QFile out(fn);
   if (out.exists())
     {	
	if (QMessageBox::
	    information(this,"Overwrite","This file exist. Overwrite it?",
			QMessageBox::Yes,QMessageBox::No) !=
	    QMessageBox::Yes)
	  return;
     }
   if ( out.open(IO_WriteOnly) )
     {
	QTextStream outs(&out);
	pl->write_to(outs);
     }
   else
     QMessageBox::warning(this,"Can't write to this file",
			  "Can't write to this file",QMessageBox::Ok,0);
}
//                                                                            
void qsipb_handtest::want_load()
{
   QString fn=QFileDialog::getOpenFileName();
   if (fn.length()==0)
     return;
   QFile in(fn);
   if ( in.open(IO_ReadOnly) )
     {
	string rez;
	rez.reserve(in.size());
	while (!in.atEnd())
	  rez+=(char)in.getch();
	pe_send->set_packet(rez);
     }
   else
     QMessageBox::warning(this,"Can't open this file",
			  "Can't open this file",QMessageBox::Ok,0);
   
}
//                                                                            
void qsipb_handtest::want_clean()
{
   pv->clear();
   ib->clear();
   pl->clear();
}
//                                                                            
void qsipb_handtest::want_send_packet()
{
   //TODO: make it in thread!
   //1.get parameters
   //get server ip
   sipb_ipaddr serv_ip;
   if (!serv_ip.try_set((const char*)le_serv->text().utf8()))
     {
	ib->add_err("Bad Server address");
	return;
     }
   //get server port
   int serv_port=le_port->text().toInt();
   //get timeout
   int ms_timeout=le_timeout->text().toInt();
   //get auto auth
   bool auto_auth=cb_autoauth->state()==QButton::On;
   //2. Send packet
   //Change via if need
   if (cb_autovia->state()==QButton::On)
     if (!change_via())
       {
	  ib->add_err("Can't change via in packet. You can send without change via");
	  return;
       }
   //Create new packet
   sipb_stpacket* p_send=new sipb_stpacket;
   pe_send->get_packet(p_send->pack,get_cob_crlf());
   
   //create new test
   pl->create_new_test();
   //from this line we start test!
   emit is_somerun();
   //send packet
   if (!tr_send->send(serv_ip.ip(),serv_port,*p_send))
     {
	ib->add_err("Can't send packet");
	if (tr_send->check_hungup())
	  ib->add_err("Probably server down");
	pl->add_packet(p_send);

	pl->set_complit();
	refresh_trans();
	emit is_somestop();
	
	return;
     }
   pl->add_packet(p_send);
   //3. Recive packet
   sipb_transport * tr_tmp=tr_recv;
   if (is_sr_same)
     tr_tmp=tr_send;
   else
     tr_send->rebind(); //its need for broken tcp
   
   sipb_stpacket* p_recv=new sipb_stpacket;
   if (!tr_tmp->recv(serv_ip.ip(),serv_port,*p_recv,ms_timeout))
     {
	ib->add_err("Not recive anything");
	if (tr_tmp->check_hungup())
	  ib->add_err("Probably server down");
	delete p_recv;
	
	pl->set_complit();
	refresh_trans();
	emit is_somestop();
	
	return;
     }
   //Do someting with recv packet
   pl->add_packet(p_recv);
   pl->set_complit();
   refresh_trans();
   emit is_somestop();
}
//                                                                            
void qsipb_handtest::want_change_tr(int id)
{
   is_sr_same=false;  //send and recive through same interface
   delete tr_send;
   delete tr_recv;
   tr_send=0;  //for safe
   tr_recv=0;
   if (cob_transport->text(id)==SIPB_TRANS_UDP)
     {
	tr_send=new sipb_udptrans;
	tr_recv=new sipb_udptrans;
     }
   else if (cob_transport->text(id)==SIPB_TRANS_TCP)
     {
	is_sr_same=true;
	tr_send=new sipb_tcptrans;
	tr_recv=new sipb_tcptrans;
     }
   else if (cob_transport->text(id)==SIPB_TRANS_TCP_BROKEN)
     {
	tr_send=new sipb_tcptrans;
	tr_recv=new sipb_tcptrans;
     }
   else
     qFatal("Error in qsipb_handtest::want_send_packet");
   ib->add_info("Wait if="+get_waitif()+
		"  wait_port="+int_to_str(get_waitport()));
}
//                                                                            
bool qsipb_handtest::change_via()
{
   string packet;
   pe_send->get_packet(packet,SIPB_CRLF);
   if (!change_in_bnfstr(packet,"SIP-message","via-parm sent-protocol transport",get_waitif()))
     return false;
   if (!change_in_bnfstr(packet,"SIP-message","via-parm sent-by port",int_to_str(get_waitport())))
     return false;
   pe_send->set_packet(packet);
   return true;
}
//                                                                            
string qsipb_handtest::get_waitif()
{
   if (is_sr_same)
     return tr_send->get_if();
   return tr_recv->get_if();
}
//                                                                            
int qsipb_handtest::get_waitport()
{
   if (is_sr_same)
     return tr_send->get_port();
      return tr_recv->get_port();
}
//                                                                            
bool qsipb_handtest::change_in_bnfstr(string&pack,string root_rule,
				      string rule_list,string to_change)
{
   bnf_parsval pv;
   int err_pos;
   string err_rule;
   if (!p.try_parse(pv,root_rule,pack,err_pos,err_rule))
     {
	ib->add_err("Can't parse myself packet");
	return false;
     }
   vector<string> rules;
   sipb_bnftools::vec_add(rule_list,rules);
   bnf_parsval* tmp_pv=0;
   for (unsigned int i=0;i<rules.size();i++)
     {
	vector<bnf_parsval*> tmp_vpv;
	if (!tmp_pv)
	  pv.get(rules[i],tmp_vpv);
	else
	  tmp_pv->get(rules[i],tmp_vpv);
	if (tmp_vpv.size()==0)
	  return false;
	tmp_pv=tmp_vpv[0];  //get first
     }
   if (!tmp_pv)
     throw logic_error("qsipb_handtest::change_in_bnfstr : empty rule_list");
   pack.replace(tmp_pv->position(),tmp_pv->get_data().size(),to_change);
   return true;
}
//                                                                            
void qsipb_handtest::refresh_trans()
{
   want_change_tr(cob_transport->currentItem());
}
//                                                                            
string qsipb_handtest::get_cob_crlf()
{
   if (cob_crlf->currentText()==SIPB_HT_CRLF_CRLF)
     return SIPB_CRLF;
   if (cob_crlf->currentText()==SIPB_HT_CRLF_CR)
     return SIPB_CR;
   if (cob_crlf->currentText()==SIPB_HT_CRLF_LF)
     return SIPB_LF;
   qFatal("logic error in qsipb_handtest::get_cob_crlf");
   return SIPB_CRLF;
}
//                                                                            
