//qsipb_handtest.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD__QSIPB_HANDTEST_H__
#define __SEGER__MLTD__QSIPB_HANDTEST_H__

#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qhbox.h>
#include "qsipb_packetedit.h"
#include "qsipb_packetview.h"
#include "qsipb_ht_plist.h"
#include "qsipb_infobar.h"
#include "sipb_stpacket.h"
#include "sipb_transport.h"
#include "bnf_parser.h"

class qsipb_handtest:public QWidget
{
   Q_OBJECT
 public:
   qsipb_handtest(QWidget* parent=0);
   ~qsipb_handtest();
 public slots:
   void want_set_packet(sipb_stpacket& rd);
 public: signals:
    //for caption change
   void is_somerun();
   void is_somestop();
 private slots:
   void want_send_packet();  //send packet (from pe_send!)
   void want_write();
   void want_load();  //want load a packet
   void want_clean();
   void want_change_tr(int i); //for signal QComboBox::activated(int)
 private:
   qsipb_packetedit* pe_send;
   qsipb_infobar* ib; //info bar
   
   qsipb_ht_plist*   pl; //packet list
   qsipb_packetview* pv; //packet view
   
   
   //parameters
   QLineEdit   *le_serv;
   QLineEdit   *le_port;
   QComboBox   *cob_transport;
   QComboBox   *cob_crlf;
   QLineEdit   *le_timeout;
   QCheckBox   *cb_autovia;
   QCheckBox   *cb_autoauth;
   
   sipb_transport* tr_send,*tr_recv;
   bool is_sr_same;
   bnf_parser p;  //for change via and auth
 private:
   bool change_via();
   string get_waitif();
   int    get_waitport();
   bool change_in_bnfstr(string& pack,string root_rule,
			 string rule_list,string s);
   void refresh_trans(); //refresh transport
   string get_cob_crlf();
};
#endif
