//qsipb_ht_plist.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_ht_plist.h"
#include "qsipb_htpwrapper.h"

qsipb_ht_plist::qsipb_ht_plist(QWidget*p):QListView(p)
{
   last_test_id=0;
   last_packet_id=0;
   last_test=0;
   last_packet=0;
   setAllColumnsShowFocus(true);
   setSorting(-1);
   setRootIsDecorated(true);
   addColumn("Number");
   addColumn("Type");
   addColumn("Time");
   addColumn("Size");
   addColumn("Status");  //Processing or Complit
   addColumn("Valid");
   
   connect(this,SIGNAL(selectionChanged(QListViewItem*)),this,
	   SLOT(want_show_packet(QListViewItem*)));
}
//                                                                            
void qsipb_ht_plist::add_packet(sipb_stpacket* packet)
{
   if (!last_test)
     create_new_test();
   last_packet=new qsipb_htpwrapper(last_test,last_packet,packet,
				    last_packet_id++);
   last_test->setText(3, QString::number(last_test->text(2).toInt() + 
					 packet->pack.size()));
}
//                                                                            
void qsipb_ht_plist::set_complit()
{
   last_test->setText(4,"Complit");
}
//                                                                            
void qsipb_ht_plist::create_new_test()
{
   last_test=new QListViewItem(this,last_test);
   last_test->setText(0,QString::number(last_test_id++));
   last_test->setText(2,QTime::currentTime().toString());
   last_test->setText(3,"0");
   last_test->setText(4,"Running");
   last_test->setPixmap(5,qsipb_pwrapper::create_vpixmap(sipb_errwarn::VT_GOOD));
}
//                                                                            
void qsipb_ht_plist::write_to(QTextStream&outs)
{
   QListViewItem* htests=firstChild();
   while (htests)
     {
	outs<<"================================================================\n";
	outs<<"Hand Test number="<<htests->text(0)<<" \n";
	QListViewItem* packs=htests->firstChild();
	while (packs)
	  {
	     qsipb_pwrapper* pw=dynamic_cast<qsipb_pwrapper*>(packs);
	     if (!packs)
	       qFatal("In qsipb_ht_plist::write_to()");
	     pw->write_to(outs);
	     packs=packs->nextSibling();
	  }
	outs<<"================================================================\n";
	htests=htests->nextSibling();
     }
}
//                                                                            
void qsipb_ht_plist::want_show_packet(QListViewItem*p)
{
   qsipb_htpwrapper* pw=dynamic_cast<qsipb_htpwrapper*>(p);
   if (pw)
     emit is_want_show_packet(pw->get_pack());
}
//                                                                            
