//qsipb_stchooser.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD__QSIPB_STCHOOSER_H_
#define __SEGER__MLTD__QSIPB_STCHOOSER_H_


#include <qhbox.h>
#include <qvbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <vector>
#include "sipb_stest.h"

using namespace std;

class qsipb_stchooser:public QHBox
{
   Q_OBJECT
 public:
   qsipb_stchooser(QWidget* parent,vector<sipb_stest*>& tests);
   ~qsipb_stchooser();
   vector<sipb_stest*> get_rez();
 private slots:
   void want_toright();        //to      pressed
   void want_toleft();         //from    pressed
   void want_all();            //all     pressed
   void want_refresh();        //refresh pressed
   void want_toright(QListViewItem*  );
   void want_toleft(QListViewItem*);
   void want_is_changeright(QListViewItem*);
 public: signals:
   void rightcurr_changed(sipb_stest*);
 private:
   void resizeEvent(QResizeEvent*);
   void set_selectlv2f(); //set selected first in lv2
                          //(or emit rightcurr_changed(0))
 private:
   QListView *lv1,*lv2;
   QVBox     *bbox;  //box for botton
   QPushButton   *btoright,*btoleft,*ball,*brefresh;
};

class qsipb_stwrapp:public QListViewItem
{   
 public:
   qsipb_stwrapp(QListView* l,sipb_stest*t):QListViewItem(l)
     {test=t; setText(0,test->name().c_str()); };
   sipb_stest* get() {return test;};
 private:
   sipb_stest* test;
};

#endif
