//qsipb_stestinfo.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)


#include <qapplication.h>
#include <stdexcept>
#include "qsipb_stestinfo.h"
#include "qsipb_stpwrapper.h"
#include "qsipb_stmanager.h"

qsipb_stestinfo::qsipb_stestinfo(QListView* parent,QListViewItem* after,
				 string name,
				 int id,sipb_stpnkeep pnk_,
				 vector<sipb_stest*> test_torun)
  :sipb_stestinfo(name),QListViewItem(parent,after)
{
   test_id       =id;
   last_packet_id=0;
   last_packet=0;
   want_stop=false;
   t.start();
   pnk=pnk_;
   psend=0;
   precv=0;
   next_todelete=0;
   gen_vt=sipb_errwarn::VT_GOOD;
   tests_after=test_torun;
   
   change_text();
   ew_output=new qsipb_ewshower(0);
}
//                                                                            
qsipb_stestinfo::~qsipb_stestinfo()
{
   delete ew_output;
   for (unsigned int i=0;i<tests_after.size();i++)
     delete tests_after[i];
   tests_after.resize(0);
}
//                                                                            
void qsipb_stestinfo::add_packet(sipb_stpacket*p)
{
   qApp->lock();
   check_uncomplit();
   
   last_packet = new qsipb_stpwrapper(this,last_packet, p, last_packet_id++);
   ew_output->ewprint(last_packet->get_pack()->errwarn,last_packet->id());
   psend+=last_packet->psend();
   precv+=last_packet->precv();
   
   //TODO:may be make interface to errwarn more simply
   gen_vt=last_packet->get_pack()->errwarn.add_vt(gen_vt);
   
   change_text();
   remove_ifneed();
   qApp->unlock();
}
//                                                                            
void qsipb_stestinfo::add_generrwarn(sipb_errwarn ew)
{
   qApp->lock();
   check_uncomplit();
   gen_errwarn += ew;
   gen_vt=gen_errwarn.add_vt(gen_vt);
   change_text();
   ew_output->ewprint(ew);
   qApp->unlock();
}
//                                                                            
void qsipb_stestinfo::set_complit()
{
   qApp->lock();
   check_uncomplit();
   _is_complit=true;
   change_text();
   
   //find qsipb_stmanager 
   QWidget* tmp=listView();
   qsipb_stmanager* stm=0;
   while (tmp && !stm)
     {
	stm=dynamic_cast<qsipb_stmanager*>(tmp); 
	if (!stm)
	  tmp=tmp->parentWidget();
     }
   if (!stm)
     qFatal("Internall Error in qsipb_stestinfo::set_complit");
   //try run next task (by sipb_stmanager)
   if (tests_after.size()>0)
     {
	stm->run_test(tests_after);
	tests_after.resize(0);
     }
   stm->test_is_complit();
   qApp->unlock();
}
//                                                                            
void qsipb_stestinfo::add_lasterrwarn(sipb_errwarn er)
{
   qApp->lock();
   if (!last_packet)
     qFatal("Internall Error in qsipb_stestinfo::add_lasterrwarn");
   last_packet->get_pack()->errwarn+=er;
   gen_vt=last_packet->get_pack()->errwarn.add_vt(gen_vt);

   last_packet->change_text();
   ew_output->ewprint(er,last_packet->id());
   qApp->unlock();
}
//                                                                            
void qsipb_stestinfo::set_wantstop()
{
   qApp->lock();
   want_stop=true;
   for (unsigned int i=0;i<tests_after.size();i++)
     delete tests_after[i];
   tests_after.resize(0);
   qApp->unlock();
}
//                                                                            
bool qsipb_stestinfo::check_wantstop()
{
   qApp->lock();
   bool rez=want_stop;
   qApp->unlock();
   return rez;
}
//                                                                            
void qsipb_stestinfo::write_to(QTextStream& outs)
{
   outs<<"================================================================\n";
   outs<<"Test ID="<<test_id<<" psend="<<psend
     <<" precv="<<precv<<"\n";
   QListViewItem* first=firstChild();
   while (first)
     {
	qsipb_stpwrapper* tmp_p=dynamic_cast<qsipb_stpwrapper*>(first);
	if (!tmp_p)
	  throw logic_error("Error in qsipb_stestinfo::write_to");
	tmp_p->write_to(outs);
	first=first->nextSibling();
     }
   outs<<"================================================================\n";
}
//                                                                            
void qsipb_stestinfo::check_uncomplit()
{
   if (_is_complit)
     qFatal("Internall error in qsipb_stestinfo (TEST COMPLIT bat used)");
}
//                                                                            
void qsipb_stestinfo::change_text()
{
   setText(0,QString::number(test_id));
   setText(1,name.c_str());
   setText(2,t.toString());
   if (is_complit())
     setText(5,"Complit");
   else 
     setText(5,"Running");
   setText(3,QString::number(psend));
   setText(4,QString::number(precv));
   setPixmap(6,qsipb_stpwrapper::create_vpixmap(gen_vt));
}
//                                                                            
void qsipb_stestinfo::remove_ifneed()
{
   if (next_todelete==0)
     next_todelete=firstChild();
   while (next_todelete && pnk.nk<childCount())
     //we need to remove
     {
	qsipb_stpwrapper* tmp_p=dynamic_cast<qsipb_stpwrapper*>(next_todelete);
	if (!next_todelete)
	  throw logic_error("Error in qsipb_stestinfo::remove_ifneed");
	bool want_del=false;
	if (tmp_p != last_packet)
	  {
	     sipb_errwarn::vt v=tmp_p->get_pack()->errwarn.get_vt();
	     if (v==sipb_errwarn::VT_GOOD && !pnk.ak_good)
	       want_del=true;
	     else if (v==sipb_errwarn::VT_WARN && !pnk.ak_warn)
	       want_del=true;
	     else if (v==sipb_errwarn::VT_ERR && !pnk.ak_err)
	       want_del=true;
	  }
	if (want_del)
	  {
	     QListViewItem* t=next_todelete;
	     next_todelete=t->nextSibling();
	     takeItem(t);
	     delete t;
	  }
	else
	  next_todelete=next_todelete->nextSibling();
     }
}
//                                                                            
