//qsipb_stestinfo.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD_QSIPB_STESTINFO_H__
#define __SEGER__MLTD_QSIPB_STESTINFO_H__
#include "sipb_stestinfo.h"
#include "qsipb_ewshower.h"
#include "qsipb_stpwrapper.h"
#include "qsipb_stpnkeep.h"
#include "sipb_stest.h"
#include "qtextstream.h"
#include <qlistview.h>

class qsipb_stestinfo:public sipb_stestinfo,public QListViewItem
{
 public:
   qsipb_stestinfo(QListView* parent, QListViewItem* after,
		   string name, int id,
		   sipb_stpnkeep pnk,vector<sipb_stest*> test_torun);
   ~qsipb_stestinfo();
   virtual void add_packet(sipb_stpacket* p);
   virtual void add_generrwarn(sipb_errwarn);
   virtual void set_complit();
   virtual void add_lasterrwarn(sipb_errwarn);
   virtual void set_wantstop();  //!! we remove test_torun_after!
   virtual bool check_wantstop();

   qsipb_ewshower* get_ew() {return ew_output;};
   int get_id()             {return test_id;};
   
   void write_to(QTextStream&);
 private:
   qsipb_ewshower* ew_output;
   int test_id;
   int last_packet_id;
   QTime t;
   qsipb_stpwrapper * last_packet;   //for last_errwarn
   bool want_stop;
   
   sipb_stpnkeep pnk;   //number of packet to keep
   QListViewItem* next_todelete; //if 0 -->then first
   int psend;
   int precv;
   sipb_errwarn::vt gen_vt;
   vector<sipb_stest*> tests_after;  //use if run serial
 private:
   void check_uncomplit();
   void change_text();
   void remove_ifneed();  //we always keep last packet!!!!
};

#endif
