//qsipb_stmanager.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include <qmessagebox.h>
#include <qapplication.h>
#include <qfiledialog.h>
#include <qsplitter.h>

#include "qsipb_stmanager.h"
#include "qsipb_stconf_dialog.h"
#include "sipb_stests.h"
#include "qsipb_stestinfo.h"
#include "qsipb_stpwrapper.h"

qsipb_stmanager::qsipb_stmanager(QWidget* parent):QVBox(parent)
{
   
   last_test_id=0;
   QHBox* hb_buttons;
   hb_buttons     =new QHBox(this);
   b_run          =new QPushButton("Run",hb_buttons);
   new QWidget(hb_buttons);
   b_stop_sel     =new QPushButton("Stop Selected",hb_buttons);
   b_stop_all     =new QPushButton("Stop All",hb_buttons);
   new QWidget(hb_buttons);
   b_clean_sel    =new QPushButton("Clean Selected",hb_buttons);
   b_clean_all    =new QPushButton("Clean All",hb_buttons);
   new QWidget(hb_buttons);
   b_save_sel     =new QPushButton("Save Selected",hb_buttons);
   b_save_all     =new QPushButton("Save All",hb_buttons);
   hb_buttons->setSpacing(10);
   hb_buttons->setMargin(3);
   
   
   QSplitter* split_h=new QSplitter(this);
   setStretchFactor(split_h,1);
   QSplitter* split_v=new QSplitter(split_h);
   split_v->setOrientation(Qt::Vertical);
   
   testlist       =new QListView(split_v);
   pv             =new qsipb_packetview(split_v);
   
   ews            =new QWidgetStack(split_h);

   QValueList<int> val_int;
   val_int.push_back(3);
   val_int.push_back(3);
   split_h->setSizes(val_int);
   val_int[1]=4;
   split_v->setSizes(val_int);

   testlist->setAllColumnsShowFocus(true);
   testlist->setSorting(-1);
   testlist->setRootIsDecorated(true);
   testlist->addColumn("Number");
   testlist->addColumn("Name");
   testlist->addColumn("Time");
   testlist->addColumn("Send");
   testlist->addColumn("Recv");
   testlist->addColumn("Status");  //Processing or Complit
   testlist->addColumn("Valid");  
   
   connect(b_run,SIGNAL(clicked()),this,SLOT(want_run()));
   connect(b_stop_sel,SIGNAL(clicked()),this,SLOT(want_stop_sel()));
   connect(b_stop_all,SIGNAL(clicked()),this,SLOT(want_stop_all()));
   connect(b_clean_sel,SIGNAL(clicked()),this,SLOT(want_clean_sel()));
   connect(b_clean_all,SIGNAL(clicked()),this,SLOT(want_clean_all()));
   connect(b_save_sel,SIGNAL(clicked()),this,SLOT(want_save_sel()));
   connect(b_save_all,SIGNAL(clicked()),this,SLOT(want_save_all()));
   
   connect(testlist,SIGNAL(selectionChanged(QListViewItem*)),
	   this,SLOT(want_show_test(QListViewItem*)));
   connect(pv,SIGNAL(is_tohandtest(sipb_stpacket&)),
	   this,SIGNAL(is_tohandtest(sipb_stpacket&)));
}
//                                                                            
void qsipb_stmanager::run_test(vector<sipb_stest*>& tests)
{
   qApp->lock();
   if (tests.size()==0)
     {
	qApp->unlock();
	return;
     }
   QListViewItem* lasttest=testlist->firstChild();
   if (lasttest)
     while (lasttest->nextSibling())
       lasttest=lasttest->nextSibling();
   vector<sipb_stest*> tests_after=tests;
   tests_after.pop_back();  //size>0
   qsipb_stestinfo*tmp=
     new qsipb_stestinfo(testlist,lasttest,
			 tests.back()->name(),
			 last_test_id++,pnk,tests_after);
   ews->addWidget(tmp->get_ew());
   sipb_stests::runtest(tmp,tests.back());
   emit is_somerun();
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::test_is_complit()
{
   emit is_somestop();
}
//                                                                            
void qsipb_stmanager::want_run()
{
   qsipb_stconf_dialog scd(gen_param,pnk); 
   if (scd.exec()==QDialog::Accepted)
     {
	vector<sipb_stest*> tests_torun=scd.get_testlist();
	pnk        =scd.get_pnk();
	gen_param  =scd.get_gen_param();
	
	qApp->lock();
	if (scd.run_serial())  //run one by one
	  run_test(tests_torun);
	else                   //run all together
	  {
	     for (unsigned int i=0;i<tests_torun.size();i++)
	       {
		  vector<sipb_stest*> tmp;
		  tmp.push_back(tests_torun[i]);
		  run_test(tmp);
	       }
	  }
	qApp->unlock();
     }
}
//                                                                            
void qsipb_stmanager::want_stop_all()
{
   qApp->lock();
   want_stop(all_tests());
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_stop_sel()
{
   qApp->lock();
   QListViewItem* sel=testlist->selectedItem();
   if (sel==0)  //nothing selected
     {
	qApp->unlock();
	return;
     }
   qsipb_stestinfo* test=dynamic_cast<qsipb_stestinfo*>(sel);
   if (test)
     want_stop(vector<qsipb_stestinfo*>(1,test));
   else 
     {
	//we want stop packet
	test=dynamic_cast<qsipb_stestinfo*>(sel->parent());
	if (!test)
	  qFatal("Error in qsipb_stmanager::want_stop_sel");
	if (QMessageBox::
	    information(this,"What are you want to stop",
			"You can't stop packet",
			"Stop test (id="+test->text(0)+")","Do nothing")==0)
	  want_stop(vector<qsipb_stestinfo*>(1,test));
     }
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_clean_all()
{
   qApp->lock();
   want_clean(all_tests());
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_clean_sel()
{
   qApp->lock();
   QListViewItem* sel=testlist->selectedItem();
   if (sel==0)  //nothing selected
     {
	qApp->unlock();
	return;
     }
   qsipb_stestinfo* test=dynamic_cast<qsipb_stestinfo*>(sel);
   if (test)
     want_clean(vector<qsipb_stestinfo*>(1,test));
   else 
     {
	//we want clean packet
	test=dynamic_cast<qsipb_stestinfo*>(sel->parent());
	if (!test)
	  qFatal("Error in qsipb_stmanager::want_clean_sel");
	if (QMessageBox::
	    information(this,"What are you want to clean",
			"You can't clean single packet",
			"Clean whole test (id="+test->text(0)+")","Do nothing")==0)
	  want_clean(vector<qsipb_stestinfo*>(1,test));
     }
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_save_all()
{
   qApp->lock();
   want_save(all_tests());
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_save_sel()
{
   qApp->lock();
   QListViewItem* sel=testlist->selectedItem();
   if (sel==0)  //nothing selected
     {
	qApp->unlock();
	return;
     }
   qsipb_stestinfo* test=dynamic_cast<qsipb_stestinfo*>(sel);
   if (test)
     want_save(vector<qsipb_stestinfo*>(1,test));
   else 
     {
	//we want save packet
	test=dynamic_cast<qsipb_stestinfo*>(sel->parent());
	if (!test)
	  qFatal("Error in qsipb_stmanager::want_save_sel");
	switch(QMessageBox::
	       information(this,"What are you want to save",
			   "You want save single packet or whole test?",
			   "Save whole test (id="+test->text(0)+")",
			   "Save packet"))
	  {
	   case 0: //save whole test
	     want_save(vector<qsipb_stestinfo*>(1,test));
	     break;
	   case 1: //want save packet
	     qsipb_stpwrapper* pack=dynamic_cast<qsipb_stpwrapper*>(sel);
	     if (!pack)
	       qFatal("Error in qsipb_stmanager::want_save_sel 2");
	     want_save(pack);
	     break;
	  }
     }
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_show_test(QListViewItem* item)
{
   qApp->lock();  //we use with test
   qsipb_stpwrapper* packet=dynamic_cast<qsipb_stpwrapper*>(item);
   qsipb_stestinfo* test=NULL;
   if (packet) //its packet
     {
	pv->set_packet(packet->get_pack());
	if (!(test=dynamic_cast<qsipb_stestinfo*>(packet->parent())))
	  qFatal("Internal error in qsipb_stmanager::want_show_test");
     }
   if (!test)
     test=dynamic_cast<qsipb_stestinfo*>(item);
   if (test)
     ews->raiseWidget(test->get_ew());
   else 
     qFatal("Bad type of item in qsipb_stmanager::want_show_test");
   qApp->unlock();
}
//                                                                            
vector<qsipb_stestinfo*> qsipb_stmanager::all_tests()
{
   qApp->lock();
   QListViewItem* first=testlist->firstChild();
   vector<qsipb_stestinfo*> rez;
   while (first)
     {
	rez.push_back(dynamic_cast<qsipb_stestinfo*>(first));
	if (!rez.back())
	  qFatal("Hm... bad error in qsipb_stmanager::all_tests");
	first=first->nextSibling();
     }
   qApp->unlock();
   return rez;
}
//                                                                            
vector<qsipb_stestinfo*> qsipb_stmanager::sel_tests()
{
   qApp->lock();
   QListViewItem* first=testlist->firstChild();
   vector<qsipb_stestinfo*> rez;
   while (first)
     {
	if (testlist->isSelected(first))
	  {
	     rez.push_back(dynamic_cast<qsipb_stestinfo*>(first));
	       if (!rez.back())
		 qFatal("Hm... bad error in qsipb_stmanager::all_tests");
	  }
	first=first->nextSibling();
     }
   qApp->unlock();
   return rez;
}
//                                                                            
void qsipb_stmanager::want_stop(vector<qsipb_stestinfo*> t)
{
   qApp->lock();
   for (unsigned int i=0;i<t.size();i++)
     t[i]->set_wantstop();
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_clean(vector<qsipb_stestinfo*> t)
{
   qApp->lock();
   for (unsigned int i=0;i<t.size();i++)
     if (t[i]->is_complit()) //we can delete it
       {
	  if (t[i]->listView()==testlist)  //test
	    {
	       testlist->takeItem(t[i]);
	       delete t[i];
	    }
	  else
	    qFatal("Error in qsipb_stmanager::want_clean");
       }
   qApp->unlock();
}
//                                                                            
void qsipb_stmanager::want_save(vector<qsipb_stestinfo*> t)
{
   if (t.size()==0)
     return;
   QString fn=QFileDialog::getSaveFileName("","",this,"Choose filename to save");
   if (fn.length()==0)
     return;
   QFile out(fn);
   if (out.exists())
     {
	if (QMessageBox::
	    information(this,"Overwrite","This file exist. Overwrite it?",
			QMessageBox::Yes,QMessageBox::No) !=
	    QMessageBox::Yes)
	  return;
     }
   if ( out.open( IO_WriteOnly ))
     {
	QTextStream outs(&out);
	for (unsigned int i=0;i<t.size();i++)
	  t[i]->write_to(outs);
     }
   else 
     QMessageBox::warning(this,"Can't write to this file",
			  "Can't write to this file",QMessageBox::Ok,0);
}
//                                                                            
void qsipb_stmanager::want_save(qsipb_stpwrapper* p)
{
   QString fn=QFileDialog::getSaveFileName("","",this);
   if (fn.length()==0)
     return;
   QFile out(fn);
   if (out.exists())
     {
	if (QMessageBox::
	    information(this,"Overwrite","This file exist. Overwrite it?",
			QMessageBox::Yes,QMessageBox::No) !=
	    QMessageBox::Yes)
	  return;
     }
   if (out.open(IO_WriteOnly))
     {
	QTextStream outs(&out);
	p->write_to(outs);
     }
   else 
     QMessageBox::warning(this,"Can't write to this file",
			  "Can't write to this file",QMessageBox::Ok,0);
}
//                                                                            
