//qsipb_stpnkeep.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_stpnkeep.h"
#include "qsipb_stpwrapper.h"
#include <qlabel.h>
#include <qvalidator.h>
#include <qlabel.h>
#include <qhbox.h>

sipb_stpnkeep::sipb_stpnkeep()
{
   ak_err =DEF_NK_AK_ERR;
   ak_warn=DEF_NK_AK_WARN;
   ak_good=DEF_NK_AK_GOOD;
   nk     =DEF_NK_NK;
}
//                                                                            
qsipb_stpnkeep::qsipb_stpnkeep(QWidget* parent,sipb_stpnkeep& def)
  :QVGroupBox(parent)
{
   QHBox * hb1=new QHBox(this);
   QHBox * hb2=new QHBox(this);
   QLabel*l1=new QLabel("N-Keep",hb1);

   le=new QLineEdit(QString().number(def.nk),hb1);
   
   le->setValidator(new QIntValidator(0,1000000,this));
   QLabel*l2=new QLabel("Always-keep",hb2);
   
   b_e=new QCheckBox(hb2);
   b_e->setPixmap(qsipb_stpwrapper::create_vpixmap(sipb_errwarn::VT_ERR));
   if (def.ak_err)
     b_e->toggle();
   
   b_w=new QCheckBox(hb2);
   b_w->setPixmap(qsipb_stpwrapper::create_vpixmap(sipb_errwarn::VT_WARN));
   if (def.ak_warn)
     b_w->toggle();
   
   b_g=new QCheckBox(hb2);
   b_g->setPixmap(qsipb_stpwrapper::create_vpixmap(sipb_errwarn::VT_GOOD));
   if (def.ak_good)
     b_g->toggle();
}
//                                                                            
sipb_stpnkeep qsipb_stpnkeep::get_rez()
{
   sipb_stpnkeep nk;
   nk.ak_err=b_e->isChecked();
   nk.ak_warn=b_w->isChecked();
   nk.ak_good=b_g->isChecked();
   nk.nk=le->text().toInt();
   return nk;
}
