//sipb_paramlist.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_paramlist.h"
#include <stdexcept>

sipb_param::sipb_param()
{
   is_int=false;
   is_global=false;
}
//                                                                            
void sipb_param::set(string name_,bool is_global_,string rez_)
{
   name     =name_;
   rez      =rez_;
   is_global=is_global_;
   is_int=false;
}
//                                                                            
void sipb_param::set_int(string name_,bool is_global_,int min_,int max_,
			 string rez_)
{
   name     =name_;
   rez      =rez_;
   is_global=is_global_;
   is_int   =true;
   int_min  =min_;
   int_max  =max_;
}
//                                                                            
void sipb_param::set_voriants(string name_,bool is_global_,
			      const vector<string>& vor)
{
   name=name_;
   is_global=is_global_;
   is_int=false;
   voriants=vor;
   if (vor.size()==0)
     throw logic_error("Error in sipb_param::set_voriant");
   rez=voriants[0];
}
//                                                                            
QValidator* sipb_param::create_val(QObject* parent)
{
   if (!is_int || voriants.size()==0)
     return NULL;
   return new QIntValidator(int_min,int_max,parent);
}
//                                                                            
void sipb_paramlist::add_wanted(string name,bool global,string def_rez)
{
   if (check_name(name))
     qFatal("Duplicate in sipb_paramlist::add_wanted");
   ps.push_back(sipb_param());
   ps.back().set(name,global,def_rez);
}
//                                                                            
void sipb_paramlist::add_wanted_int(string name,bool global,int min,int max,
				     string def_rez)
{
   if (check_name(name))
     qFatal("Duplicate in sipb_paramlist::add_wanted_int");
   ps.push_back(sipb_param());
   ps.back().set_int(name,global,min,max,def_rez);
}
//                                                                            
void sipb_paramlist::add_wanted_voriants(string name,bool global,
					 const vector<string>&vor)
{
   if (check_name(name))
     qFatal("Duplicate in sipb_paramlist::add_wanted_int");
   ps.push_back(sipb_param());
   ps.back().set_voriants(name,global,vor);
}
//                                                                            
string sipb_paramlist::get(string name)
{
   for (int i=0;i<size();i++)
     if (get_name(i)==name)
       return get_rez(i);
   qFatal("Error in sipb_paramlist::get name=%s",name.c_str());
   return "";
}
//                                                                            
int sipb_paramlist::get_int(string name)
{
   string tmp=get(name);
   return atoi(tmp.c_str());
}
//                                                                            
bool sipb_paramlist::check_name(string name)
{
   for (int i=0;i<size();i++)
     if (get_name(i)==name)
       return true;
   return false;
}
//                                                                            
void sipb_paramlist::copy_new_toglobal(sipb_paramlist& glo)
{
   for (int i=0 ; i<size() ; i++)
     if (get_is_global(i) && !glo.check_name(get_name(i)))
       glo.ps.push_back(ps.at(i));
}
//                                                                            
void sipb_paramlist::set_fromglobal(sipb_paramlist&glo)
{
   for (int i=0;i<size();i++)
     if (get_is_global(i))
       set_rez(i,glo.get( get_name(i) ));  //if not fount error!!!
}
//                                                                            
void sipb_paramlist::set_rez(int p,string rez_str)
{
   if (ps.at(p).voriants.size()!=0)
     {
	bool def=false;
	for (unsigned int i=0;i<ps[p].voriants.size();i++)
	  if (ps[p].voriants[i]==rez_str)
	    def=true;
	if (!def)
	  qFatal("Error in sipb_paramlist::set_rez not find voriant");
     }
   ps.at(p).rez=rez_str;
}
//                                                                            
void sipb_paramlist::set_rez(string name,string rez_str)
{
   for (int i=0 ; i<size() ; i++)
     if (get_name(i) == name)
       {
	  set_rez(i,rez_str);
	  return;
       }
   qFatal("Error in sipb_paramlist::set_rez");
}
//                                                                            
