//sipb_sendrecv_udp.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_sendrecv_udp.h"
#include "sipb_netfun.h"
#include <stdexcept>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/ioctl.h>
#include <linux/sockios.h>
#include <errno.h>
#include <string.h>
#include <string>


using namespace std;  //for runtime_error

//                                                                            
sipb_sendrecv_udp::sipb_sendrecv_udp()
{
   if (( soc=socket(PF_INET,SOCK_DGRAM,0) ) == -1)
     throw runtime_error("Error then try create udp-socket");
   _is_connect=false;
   sipb_netfun::bind_any(soc);
}
//                                                                            
int sipb_sendrecv_udp::get_port()
{
   return sipb_netfun::get_port(soc);
}
//                                                                            
void sipb_sendrecv_udp::rebind()
{
   close(soc);
   if (( soc=socket(PF_INET,SOCK_DGRAM,0) ) == -1)
     throw runtime_error("Error then tray create udp-socket");
   _is_connect=false;
   sipb_netfun::bind_any(soc);
}
//                                                                            
bool sipb_sendrecv_udp::make_connect(in_addr addr,int port)
{
   if (is_connect())
     throw logic_error("Error in sipb_sendrecv_udp::make_connect alredy connect");
   sockaddr_in dest_soca;
   sipb_netfun::create_sockaddr_in(dest_soca,addr,port);
   if (connect(soc, (sockaddr*)&dest_soca, sizeof(dest_soca))<0)
     return false;  //can't connect
   _is_connect=true;
   return true;
}
//                                                                            
bool sipb_sendrecv_udp::sendudp(const string& data)
{
   //create socketaddr
   if (!is_connect())
     throw logic_error("Error in sipb_sendrecv_udp::sendudp");
   if (check_hungup())
     return false;
   if (send(soc, data.data(), data.size(),0)==-1)
     return false;
   if (check_hungup())
     return false;
   return true;
}
//                                                                            
bool sipb_sendrecv_udp::check_hungup()
{
   if ( sipb_netfun::poll_event(soc,0,0) == sipb_netfun::PERR ) //some error
     return true;
   return false;
}
//                                                                            
bool sipb_sendrecv_udp::recvudp(in_addr& s_ip, int& s_port,
				string& data, int ms_timeout)
{
   if (is_connect())
     throw logic_error("Error in  sipb_sendrecv_udp::recvudp must be disconnect");
   sipb_netfun::poll_rez rez=sipb_netfun::poll_inevent(soc,ms_timeout);
   if (rez != sipb_netfun::PGOOD)  //timeout
     return false;
   
   int size;
   int err = ioctl(soc,SIOCINQ,&size);
   if (err<0 || size<=0)
     throw runtime_error("Error in sipb_recvudp() then run ioctl: "+
			 string(strerror(errno)));
   //read message
   
   char *buf=new char[size+1];
  
   sockaddr_in sa;
   socklen_t sa_len=sizeof(sa);
   if ( (size=recvfrom(soc, (void*)buf, size + 1, 0,
		       (sockaddr*)&sa, &sa_len)) == -1)
     throw runtime_error(string("Error in sipb_sendrecv_udp::sipb_recvudp() ")+
			 "then run recv :"+strerror(errno));
   if (sa_len!=sizeof(sa))
     throw runtime_error("Internall error in sipb_sendrecv_udp::recvudp sa_len!=sizeof(sockaddr_in)");
   s_ip=sa.sin_addr;
   s_port=ntohs(sa.sin_port);
   
   data.assign(buf,size);
   delete buf;
   return true;
}
//                                                                            
