//sipb_packetinfo.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD_SIPB_STPACKET_H__
#define __SEGER__MLTD_SIPB_STPACKET_H__

#include "sipb_errwarn.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <string>
#include <qdatetime.h>
using namespace std;

class sipb_stpacket
{
 public:
   string       pack;      //self packet
   QTime        t;         //time then packet was send/reciv 
   string       type;      //type of packet (udp/tcp/udp6 .... )
   bool         is_send;   //true -- send  false -- recive
   in_addr      serv_ip;   //ip of serverd
   int          serv_port; //port of server 
   int          my_port;   //port of mine
   int          nsend;     //number of resend (we can resend packet...)
                           //if (!is_send )--> not mean
   
   sipb_errwarn errwarn;  //error and warnings (usefull only then
                          // is_send=false)
 public:
   sipb_stpacket()
     {
	t.start();
	nsend=0;
     }
   void add_warning(string str){errwarn.add_warning(str);};
   void add_error(string str)  {errwarn.add_error(str);};
   void add_info(string str)   {errwarn.add_info(str);};
   void set_typeudp(){type="UDP";};
   void set_typetcp(){type="TCP";};
 public:
   sipb_errwarn::vt get_vt(){return errwarn.get_vt();};
};

#endif
