//sipb_md5.cpp
#include "sipb_md5.h"
#include <md5global.h>
#include <md5.h>

//                                                                            
string sipb_md5::create_dresp(string username,string realm,
			    string password,string method,
			    string uri,string nonce)
{
   MD5_CTX Md5Ctx;    
   char ha1[MD5_HASHLEN];
   char ha2[MD5_HASHLEN];
   char resp[MD5_HASHLEN];
   string ha1_hex,ha2_hex;
   
   MD5Init(&Md5Ctx);
   MD5Update(&Md5Ctx, username.c_str(), username.size());
   MD5Update(&Md5Ctx, ":", 1);
   MD5Update(&Md5Ctx, realm.c_str(), realm.size());
   MD5Update(&Md5Ctx, ":", 1);
   MD5Update(&Md5Ctx, password.c_str(), password.size());
   MD5Final(ha1, &Md5Ctx);
   ha1_hex=cvt_hex(&ha1[0]);
   
   MD5Init(&Md5Ctx);
   MD5Update(&Md5Ctx, method.c_str(), method.size());
   MD5Update(&Md5Ctx, ":", 1);
   MD5Update(&Md5Ctx, uri.c_str(), uri.size());
   MD5Final(ha2, &Md5Ctx);
   ha2_hex=cvt_hex(&ha2[0]);
    
   MD5Init(&Md5Ctx);
   MD5Update(&Md5Ctx, ha1_hex.c_str(), HASHHEXLEN);
   MD5Update(&Md5Ctx, ":", 1);
   MD5Update(&Md5Ctx, nonce.c_str(), nonce.size());
   MD5Update(&Md5Ctx, ":", 1);
   MD5Update(&Md5Ctx, ha2_hex.c_str(), HASHHEXLEN);
   MD5Final(resp, &Md5Ctx);
   return cvt_hex(&resp[0]);
}
//                                                                            
string sipb_md5::cvt_hex(char* in)
{
   unsigned short i;
   unsigned char j;
   string out;
   out.resize(MD5_HASHLEN*2);
   for (i = 0; i < MD5_HASHLEN; i++) 
     {
	j = (in[i] >> 4) & 0xf;
	if (j <= 9) 
	  out[i * 2] = (j + '0');
	else 
	  out[i * 2] = (j + 'a' - 10);
	j = in[i] & 0xf;
	if (j <= 9) 
	  out[i * 2 + 1] = (j + '0');
	else 
	  out[i * 2 + 1] = (j + 'a' - 10);
     };
   return out;
}
//                                                                            
