//sipb_stest.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD__SIPB_STEST_H__
#define __SEGER__MLTD__SIPB_STEST_H__

#include "sipb_stestinfo.h"
#include "sipb_paramlist.h"

class sipb_stest
{
 public:
   sipb_stest();  //you must addwanted parameters in constructor
   virtual ~sipb_stest();
   void work(sipb_stestinfo *test);
   virtual string name()=0;
   sipb_paramlist* paramlist()         {return _param;};
 protected:
   virtual void work()=0;
   //interface to testinfo
   void push_packet(sipb_stpacket*);
   void add_gen_warning(string str);
   void add_gen_error(string str);
   void add_gen_info(string str);
   void add_gen_errwarn(sipb_errwarn& ew) {testinfo->add_generrwarn(ew);};
   void add_last_warning(string str);
   void add_last_error(string str);
   void add_last_info(string str);
   void add_last_errwarn(sipb_errwarn& ew) {testinfo->add_lasterrwarn(ew);};
   bool check_wantstop()   {return testinfo->check_wantstop() || want_stop;};
   void set_wantstop()     { want_stop=true;};
 private:
   sipb_stestinfo* testinfo;
   sipb_paramlist*  _param;
   bool want_stop;
};

#endif
