//sipbst.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef  __SEGER__MLTD__SIPBST_H__
#define  __SEGER__MLTD__SIPBST_H__
#include "sipbst_sendrecv.h"
#include "sipbst_grammsip.h"
#include "bnf_parser.h"

class sipbst_garbage:public sipbst_sendrecv
{
 public:
   sipbst_garbage(); //add parameters
   string name(){return "Garbage";};
 protected:
   void _work();
   void run_beforework();
 private:
   int line_size;
   int  n_line;
};

class sipbst_random:public sipbst_sendrecv
{
 public:
   sipbst_random(); //add paramters
   string name(){return "RANDOM";};
 protected:
   void _work();
   void run_beforework();
 private:
   int rand_param;
   bnf_parser p;
};

class sipbst_opt_val:public sipbst_grammsip
{   
 public:
   string name() {return "OPTIONS_valid";} ;
 protected:
   void _work();
   void _run_beforework(){};
};

class sipbst_opt_req:public sipbst_grammsip
{
 public:
   string name(){return "OPTIONS_req";};
 protected:
   void _work();
   void _run_beforework(){};
};

class sipbst_opt_totag:public sipbst_grammsip
{
 public:
   string name(){return "OPTIONS_totag";};
 protected:
   void _work();
   void _run_beforework(){};
};


class sipbst_opt_bad1:public sipbst_grammsip
{
 public:
   sipbst_opt_bad1(); //add paramters
   string name(){return "OPTIONS_bad1";};
 protected:
   void _work();
   void _run_beforework();
 private:
   int max_clen;
   int c_quan;
};

class sipbst_reg_val:public sipbst_grammsip
{
 public:
   sipbst_reg_val();  //add paramters  (password)
   string name(){return "REGISTER_valid";};
 protected:
   void _work();
   virtual void _run_beforework();
 protected:
   string password;
};

class sipbst_reg_exp:public sipbst_grammsip
{
 public:
   sipbst_reg_exp();
   string name(){return "REGISTER_expir";};
 protected:
   void _work();
   virtual void _run_beforework();
 private:
   string password;
   int expires;
};

class sipbst_reg_del:public sipbst_reg_val //delete record
{
 public:
   string name(){return "REGISTER_del";};
 protected:
   void _work();
};

class sipbst_reg_cseq:public sipbst_reg_val //delete record
{
 public:
   string name(){return "REGISTER_cseq";};
 protected:
   void _work();
};


class sipbst_reg_mcont:public sipbst_reg_val
{
 public:
   string name(){return "REGISTER_mcont";};
 protected:
   void _work();
};

class sipbst_reg_mcexp:public sipbst_grammsip
{
 public:
   sipbst_reg_mcexp();
   string name(){return "REGISTER_mcexpir";};
 protected:
   void _work();
   virtual void _run_beforework();
 private:
   string password;
   int expires;
};

class sipbst_reg_mcdel:public sipbst_reg_val //delete record
{
 public:
   string name(){return "REGISTER_mcdel";};
 protected:
   void _work();
};

//invite simple valid (inv-s-val)
class sipbst_invsval_caller:public sipbst_grammsip
{
 public:
   sipbst_invsval_caller();
   virtual string name(){return "INVITE_sv_caller";};
 protected:
   virtual void _run_beforework();
   virtual void _work();
 private:
   string username2;
   string password;
   int ms_pause; //milisecond
};

//invite simple valid (inv-s-val)
class sipbst_invsval_callee:public sipbst_grammsip
{
 public:
   sipbst_invsval_callee();
   virtual string name(){return "INVITE_sv_callee";};
 protected:
   virtual void _run_beforework();
   virtual void _work();
 private:
   string username2;
   string password2;
};

#endif
