//sipbst_grammsip.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef  __SEGER__MLTD__SIPBST_GRAMMSIP_H__
#define  __SEGER__MLTD__SIPBST_GRAMMSIP_H__
#include "sipbst_sendrecv.h"
#include "bnf_parser.h"

class sipbst_grammsip:public sipbst_sendrecv
  //gramatic sip packet
{
 public:
   sipbst_grammsip();
 protected:
   void run_beforework();
   virtual void _run_beforework()=0;
 protected:
   bool create_sendrecv(string rule_cr);
             //simple behavior
             //create packet by pcr --> try_send (if not retrun false)
             //if send return true
          
   bool create_sr_parse(string rule1="Request",string rule2="Response");
             //(create_sendrecv_parse)
             //create packet by pcr --> try_send (if not retrun false)  
             //parse send (by pps to pv_send) parse recv (by ppr to pv_recv)
             //if error return false
             //if true last_packet --> send (we can add_last_errwarn)
   bool recv_parse(string rule="Response");
             //wait incoming packet
             //parse recived packet
   bool reparse_send(string rule); 
   bool av_csrp_reqresp(bool ignore_1xx=true);
             //(add_via_create_sendrecv_parse for request_response)
             //Add currect via paramter
             //run cerate_send_parse()
             //run sipb_bnftools::check_base_req for recived packet
             //if ignore_1xx  - if we recive 1xx responce then we
             //   make warning and ignore it
   bool av_csrprr_auth(string method, string uri , string username,
			string password,int max_contlen , string nec,
			string opt="",bool ignore_1xx=true);
              //(add via create send recive parse for request responce 
              // with authorization)
              //Specific behavior : look in sourse code
              //(Use it only if you know what you do)
   bool simple_register(string username,string password);
      //make simple registration on server
 protected:
   string username,userhost_name;
   int max_contlen;
   int rand_param;   
   bnf_parser pcr;  //for create packet
   bnf_parser pps;  //for parse send packet
   bnf_parser ppr;  //for parse recv packet
 protected:
   bnf_parsval pv_recv,pv_send;  //use by create_send_parse
   int status_code;              //use only after csp_req_resp
 protected:
   //some status code function
   bool is_2xx_status(){return status_code>=200 && status_code<=299;};
   bool is_4xx_status(){return status_code>=400 && status_code<=499;};
   bool is_1xx_status(){return status_code>=100 && status_code<=199;};
   bool is_1xx_status_not100(){return status_code>100 && status_code<=199;};
   
   bool check_2xx_status();
     //if status not 2xx --> 1. add_last_error
     //                      2. return false
     //if status 2xx     --> return true
 private:
   string sgram_change; //it's not need for other
};

#endif
