//sipbst_invsval_caller.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "sipb_bnftools.h"
#include "sipb_addfun.h"

sipbst_invsval_caller::sipbst_invsval_caller()
{
   paramlist()->add_wanted(SIPB_SP_PASSWORD,true,SIPB_SP_PASSWORD_DEF);
   paramlist()->add_wanted(SIPB_SP_USERNAME2,true,SIPB_SP_USERNAME2_DEF);
   paramlist()->add_wanted_int(SIPB_SP_MS_PAUSE,true,0,SIPB_SP_MAX_INT,
			       SIPB_SP_MS_PAUSE_DEF);
}
//                                                                            
void sipbst_invsval_caller::_run_beforework()
{
   password=paramlist()->get(SIPB_SP_PASSWORD);
   username2=paramlist()->get(SIPB_SP_USERNAME2);
   ms_pause=paramlist()->get_int(SIPB_SP_MS_PAUSE);
}
//                                                                            
void sipbst_invsval_caller::_work()
{
   //Make registration
   if (!simple_register(username,password))  //view sipbst_grammsip for detail
     return;
   //make pause after registration
   if (ms_pause<1000)
     usleep(ms_pause*1000);
   else
     sleep(ms_pause/1000);
   //Create and send INVITE packet
   sipb_bnftools::set_rulebydef(pcr);
   sipb_bnftools::set_reqline(pcr,"INVITE",servhost_name,username2,
			      get_servport());
   sipb_bnftools::set_maxfor(pcr , random()%70 + 1);
   sipb_bnftools::set_to_nottag(pcr, servhost_name,username2,1024 +random()%30000);
   sipb_bnftools::set_cseq(pcr,"INVITE");
   sipb_bnftools::set_expires(pcr,3600);
   sipb_bnftools::set_from(pcr,servhost_name,username,1024 +random()%30000 );
   sipb_bnftools::set_contact(pcr, userhost_name, username,
			      get_waitport(),false); //set port!
   string uri=string("sip:")+username+"@"+servhost_name;
   if (!av_csrprr_auth("INVITE",uri,username,password,max_contlen,"Contact",
		       "Expires",false))  //Expires optionaly
                                          //not ignore 1xx
     return;
   //we expect to recive 1xx message or non-2xx final or 2xx
   //TODO: we can send Bye after recive 
   while (1)
     {
	if (status_code==100)  //we can send CANCEL (but can't send BYE)
	  {
/*	     if ((random() % 3) ==0 )  //1/4 :)
	       {
		  //Create CANCEL request
		  sipb_bnftools::create_cancel(pcr,pv_recv);
		  if (!av_csrp_reqresp()) 
		    return;
		  
	       }*/
	  }
	else if (is_4xx_status())
	  {
	     add_last_info("We recive 4xx after INVITE -- probobly INVITE reject "
			   "or you not run INVITE_sv_callee");
	     return;
	  }
	else if (is_2xx_status())
	  {
	     add_last_info("We recive 2xx after INVITE -- INVITE accepted :)");
	     //we not send ACK --> becouse it's go past server
	     return;
	  }
	if (!is_1xx_status())
	  {
	     add_last_error("We recive unexpected message status="+
			    int_to_str(status_code));
	     return;
	  }
	//recive next message
	if (!recv_parse())
	  return;
     }
}
//                                                                            
