//sipbst_opt_totag.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_addfun.h"

//                                                                            
void sipbst_opt_totag::_work()
{
   sipb_bnftools::set_rulebydef(pcr);
   if (random()%2)  //may be to host and maxforwards>0
     {
	sipb_bnftools::set_reqline(pcr, "OPTIONS", servhost_name,"",
				   get_servport());
	sipb_bnftools::set_maxfor(pcr,70);
     }
   else             //may be to any and maxforwards=0
     {	
	sipb_bnftools::set_randhost_reqline(pcr,"OPTIONS");
	sipb_bnftools::set_maxfor(pcr,0);
     }
   sipb_bnftools::set_via(pcr, userhost_name,get_waitif(),get_waitport());
   sipb_bnftools::set_to_withtag(pcr, servhost_name,"",get_servport());
   sipb_bnftools::set_cseq(pcr,"OPTIONS");
   sipb_bnftools::set_from(pcr,userhost_name,username,get_waitport());
      
   sipb_bnftools::set_request(pcr,random() % (max_contlen + 1),"",
			      "Contact Expires",!is_reliable_trans());
   
   
   if (!av_csrp_reqresp()) return;
   if (status_code!=481)
     add_last_error("We send packet with to-tag (inside non-existent dialog )"
		    " we expect 481 (Call/Transaction Does Not Exist) "
		    " status-code (12.2.2 rfc3261 for detail)");
   return;
}
