//sipbst_reg_cseq.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_md5.h"
#include "sipb_addfun.h"

//                                                                            
void sipbst_reg_cseq::_work()
{
   int port1 = 10000 + random() % 10000;
   int port2 = 30000 + random() % 10000;
   bool is_cseq_up= !(random() % 4);   //1/4  --> update CSeq
   int cseq1 = 5 + random()%1000000;
   int cseq2;
   if (is_cseq_up)
     cseq2 = cseq1+1+random() % 5;
   else
     cseq2 = cseq1 - random() % 5;
   bool is_cid_change= !(random() % 4);  //1/4 --> change Call-ID
   string cid1=sipb_bnftools::nalpha(10);
   string cid2;
   if (is_cid_change)
     cid2=sipb_bnftools::nalpha(12);
   else
     cid2=cid1;
   //FIRST REQUEST
   sipb_bnftools::set_rulebydef(pcr);
   sipb_bnftools::set_reqline(pcr,"REGISTER",servhost_name,"",get_servport());
   sipb_bnftools::set_maxfor(pcr , random()%70 + 1);
   sipb_bnftools::set_to_nottag(pcr, servhost_name, username,1024 + random()%30000);
   sipb_bnftools::set_cseq(pcr,"REGISTER",cseq1);
   sipb_bnftools::set_callid(pcr , cid1);
   sipb_bnftools::set_from(pcr,servhost_name,username,1024 +random()%30000 );
   sipb_bnftools::set_contact(pcr, userhost_name, username,
			      port1,false,"Contact"); 
   sipb_bnftools::set_expires(pcr,60);
   string uri=string("sip:")+username+"@"+servhost_name;   
   if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
		       "Contact","Expires"))
     return;
   if (!check_2xx_status())
     return;
   sipb_errwarn ew;
   sipb_bnftools::check_regcontact(&pv_recv,&pv_send,ew);
   add_last_errwarn(ew);
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");

   //Change update request (new port)
   //may be change callid and may be + or - Cseq
   sipb_bnftools::set_contact(pcr, userhost_name, username,
			      port2,false,"Contact");
   sipb_bnftools::set_cseq(pcr,"REGISTER",cseq2);
   sipb_bnftools::set_callid(pcr , cid2);
   
   if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
		       "Contact","Expires"))
     return;
   if (!check_2xx_status())
     return;
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");
   
   if ( (!is_cid_change) && (!is_cseq_up) )  //must not change
      //we not change Call-ID and not update CSeq
     {
	if (!sipb_bnftools::find_contact_port(&pv_recv,port1) ||
	     sipb_bnftools::find_contact_port(&pv_recv,port2))
	  {
	     add_last_error("We find in responce second-contact port="+
			    int_to_str(port2)+
			    " or not find first-contact port="+
			    int_to_str(port1) + " (server update Contact). "
			    "But we send second REGISTER with CSeq-value "
			    "less or equal CSeq-value in first REGISTER "
			    "and we not change Call-ID "
			    "(rfc3261 10.3 for detail)");
	  }
     }
   else 
     {
	if (!sipb_bnftools::find_contact_port(&pv_recv,port2))
	  {
	     add_last_error("We not find in responce second-contact port=" + 
			    int_to_str(port2)+". But Server must be Update "
			    "Contact (we update Cseq or change Call-ID)");
	     if (!sipb_bnftools::find_contact_port(&pv_recv,port1))
	       add_last_warning("Can't find contact from first packet port="+
				int_to_str(port1));
	  }
     }
}

