//sipbst_sendrecv.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//parent of all my test (CERT test not mine :))
#ifndef __MLTD__SIPBST_SENDRECV_H__
#define __MLTD__SIPBST_SENDRECV_H__

#include "sipb_stest.h"
#include "sipb_ipaddr.h"
#include "sipb_transport.h"
using namespace std;

class sipbst_sendrecv:public sipb_stest
{
 public:
   sipbst_sendrecv();
   virtual ~sipbst_sendrecv();
 protected:
   void work();
   virtual void _work()=0;
   virtual void run_beforework()=0;
 protected:
   bool send_recv(sipb_stpacket* tosend,sipb_stpacket* torecv);
        //if torecv==NULL not wait packet
        //return true if resive
        //this function NOT delete or push_packet(...) with tosend and torecv
   bool recv(sipb_stpacket* torecv); 
        //simple recive packet (if NULL do nothing and return false)
   bool send(sipb_stpacket* tosend);
        //simple send packet
   int get_waitport();
   string get_waitif();
   int get_servport(){return serv_port();};
   bool is_reliable_trans(){return tr_send->is_reliable_trans();}; 
             //is need then we add Content-length
 protected:
   sipb_ipaddr serv_ip;
   string servhost_name;
 private:
   int udp_port,tcp_port;
   int n_send,n_resend,resend_timeout;
   string transport;  //may be UDP TCP TCP(broken) ANY
   sipb_transport* tr_send,*tr_recv;
   bool is_sr_same;   //is send and resive for same transport (for_send)
 private:
   void refresh_net();  //change for_send for_recive and is_sr_same
   int serv_port();    //choose server port
};

#endif
